/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.trainer;

import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameClientState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.duel.state.TrainerCardState;
import com.pixelmonmod.tcg.duel.trainer.BaseTrainerEffect;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class Pokedex
extends BaseTrainerEffect {
    @Override
    public boolean canPlay(GameClientState client) {
        return client.getMe().getDeckSize() > 0;
    }

    @Override
    public CardSelectorState getSelectorState(TrainerCardState trainer, GameServerState server) {
        int count = Math.min(5, server.getPlayer(server.getCurrentTurn()).getDeck().size());
        int skip = trainer.getParameters().size();
        ArrayList<CommonCardState> top = new ArrayList<CommonCardState>();
        for (int i = 0; i < count; ++i) {
            top.add(new CommonCardState(server.getPlayer(server.getCurrentTurn()).getDeck().get(i)));
        }
        for (CommonCardState selected : trainer.getParameters()) {
            CommonCardState match = top.stream().filter(c -> c.getData() == selected.getData()).findFirst().get();
            top.remove(match);
        }
        CardSelectorState selector = new CardSelectorState(1, 1, CardSelectorDisplay.Select, false, "trainer.pokedex.selector." + Integer.toString(skip + 1));
        selector.getCardList().addAll(top.stream().map(c -> new CardWithLocation((CommonCardState)c, true, BoardLocation.Deck, 0)).collect(Collectors.toList()));
        return selector;
    }

    @Override
    public boolean canApply(TrainerCardState trainer, GameServerState server) {
        return trainer.getParameters().size() == Math.min(5, server.getPlayer(server.getCurrentTurn()).getDeck().size());
    }

    @Override
    public void apply(TrainerCardState trainer, GameServerState server) {
        int index = 0;
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        for (CommonCardState card : trainer.getParameters()) {
            player.getDeck().remove(index);
            player.getDeck().add(index, card.getData());
            ++index;
        }
    }

    @Override
    public boolean canSkipSelector() {
        return false;
    }

    @Override
    public void applySkipSelector(TrainerCardState trainer, PokemonCardState pokemon, GameServerState server, BoardLocation b, int p) {
    }
}

