/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.tcg.duel.attack.effects;

import com.pixelmonmod.tcg.api.card.Energy;
import com.pixelmonmod.tcg.api.card.ImmutableCard;
import com.pixelmonmod.tcg.api.card.attack.CardAttack;
import com.pixelmonmod.tcg.client.gui.duel.CardWithLocation;
import com.pixelmonmod.tcg.client.gui.enums.CardSelectorDisplay;
import com.pixelmonmod.tcg.duel.attack.effects.BaseAttackEffect;
import com.pixelmonmod.tcg.duel.state.CardSelectorState;
import com.pixelmonmod.tcg.duel.state.CommonCardState;
import com.pixelmonmod.tcg.duel.state.GameServerState;
import com.pixelmonmod.tcg.duel.state.PlayerServerState;
import com.pixelmonmod.tcg.duel.state.PokemonAttackStatus;
import com.pixelmonmod.tcg.duel.state.PokemonCardState;
import com.pixelmonmod.tcg.network.packets.enums.BoardLocation;
import java.util.List;
import java.util.stream.Collectors;

public class WildfireEffect
extends BaseAttackEffect {
    private static final String CODE = "WILDFIRE";
    private Energy energy;

    public WildfireEffect() {
        super(CODE);
    }

    @Override
    public CardSelectorState getSelectorState(List<Object> parameters, GameServerState server) {
        if (parameters.size() == 0) {
            List<CommonCardState> energyCards = this.getEnergyCards(server);
            for (CommonCardState card : energyCards) {
                if (card.getMainEnergy() == this.energy) continue;
                energyCards.remove(card);
            }
            CardSelectorState selector = new CardSelectorState(1, Math.min(energyCards.size(), server.getPlayer(server.getNextTurn()).getDeck().size()), CardSelectorDisplay.Discard, false, "Discard Energy");
            int count = 0;
            for (CommonCardState card : energyCards) {
                selector.getCardList().add(new CardWithLocation(card, true, BoardLocation.Attachment, 0));
                if (server.getPlayer(server.getNextTurn()).getDeck().size() != ++count) continue;
                return selector;
            }
            return selector;
        }
        return null;
    }

    @Override
    public boolean canApply(List<Object> parameters, CardAttack cardAttack, GameServerState server) {
        return parameters.size() > 0 || server.getPlayer(server.getNextTurn()).getDeck().size() < 1;
    }

    @Override
    public void applyBeforeDamage(List<Object> parameters, PokemonAttackStatus attack, PokemonCardState card, GameServerState server) {
        PlayerServerState applyingPlayer = server.getPlayer(server.getCurrentTurn());
        PlayerServerState oppPlayer = server.getPlayer(server.getNextTurn());
        for (Object parameter : parameters) {
            CommonCardState attachment = (CommonCardState)parameter;
            card.getAttachments().remove(attachment);
            applyingPlayer.getDiscardPile().add(attachment.getData());
            if (oppPlayer.getDeck().isEmpty()) continue;
            ImmutableCard toDiscard = oppPlayer.getDeck().get(0);
            oppPlayer.getDeck().remove(0);
            oppPlayer.getDiscardPile().add(toDiscard);
        }
    }

    private List<CommonCardState> getEnergyCards(GameServerState server) {
        PlayerServerState player = server.getPlayer(server.getCurrentTurn());
        return player.getActiveCard().getAttachments().stream().filter(CommonCardState::isEnergyEquivalence).collect(Collectors.toList());
    }

    @Override
    public BaseAttackEffect parse(String ... args) {
        this.energy = Energy.getEnergyFromString(args[1]);
        return super.parse(args);
    }
}

