/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.structure.type.ultraspace;

import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.world.structure.PixelmonStructures;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.ScatteredStructurePiece;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class CraterGeyserPiece
extends ScatteredStructurePiece {
    private static final ResourceLocation LOOT_TABLE = ResourceLocationHelper.of("pixelmon", "chests/ultraspace/crater_geyser");

    public CraterGeyserPiece(Random p_i51344_2_, int p_i51344_3_, int p_i51344_5_, int radius) {
        super(PixelmonStructures.GEYSER, p_i51344_2_, p_i51344_3_, 64, p_i51344_5_, radius * 2, RandomHelper.getRandomNumberBetween(20, 40) * 2, radius * 2);
    }

    public CraterGeyserPiece(TemplateManager templateManager, CompoundNBT compoundNBT) {
        super(PixelmonStructures.GEYSER, compoundNBT);
    }

    public boolean func_230383_a_(ISeedReader level, StructureManager structureManager, ChunkGenerator generator, Random random, MutableBoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
        int originY = pos.func_177956_o();
        int originZ = pos.func_177952_p();
        int originX = pos.func_177958_n();
        BlockPos.Mutable mutablePos = pos.func_239590_i_();
        int maxHeight = this.field_202582_b / 2;
        int maxRadius = this.field_202583_c / 2;
        int numPoints = 900;
        int minRadius = RandomHelper.getRandomNumberBetween(10, 15);
        boolean chestPlaced = false;
        for (int h = 0; h < maxHeight; ++h) {
            double radius = (double)(maxRadius * (maxHeight - h)) / (double)maxHeight;
            if (radius < (double)minRadius) continue;
            for (int i = 0; i < numPoints; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)numPoints;
                mutablePos.func_189532_c((double)originX + radius * Math.cos(angle), (double)(originY + h), (double)originZ + radius * Math.sin(angle));
                level.func_180501_a((BlockPos)mutablePos, h < 6 ? Blocks.field_196830_iD.func_176223_P() : Blocks.field_196836_iG.func_176223_P(), 2);
            }
            int r = 0;
            while ((double)r < radius) {
                for (int i = 0; i < numPoints; ++i) {
                    double angle = Math.PI * 2 * (double)i / (double)numPoints;
                    mutablePos.func_189532_c((double)originX + (double)r * Math.cos(angle), (double)(originY + h), (double)originZ + (double)r * Math.sin(angle));
                    if (!level.func_180495_p((BlockPos)mutablePos).func_203425_a(Blocks.field_150350_a)) continue;
                    level.func_241211_a_((BlockPos)mutablePos, h == 0 ? Blocks.field_196814_hQ.func_176223_P() : Blocks.field_150355_j.func_176223_P(), 0, 0);
                    if (h != 1 || !RandomHelper.getRandomChance(0.001f) || chestPlaced) continue;
                    chestPlaced = true;
                    level.func_180501_a((BlockPos)mutablePos, Blocks.field_150486_ae.func_176223_P(), 2);
                    LockableLootTileEntity.func_195479_a((IBlockReader)level, (Random)random, (BlockPos)mutablePos, (ResourceLocation)LOOT_TABLE);
                }
                ++r;
            }
        }
        return true;
    }
}

