/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.world.listener;

import com.pixelmonmod.pixelmon.api.events.CaptureEvent;
import com.pixelmonmod.pixelmon.api.util.helpers.EntityHelper;
import com.pixelmonmod.pixelmon.world.dimension.drowned.DrownedWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class DrownedWorldListener {
    public static final String DROWNED_LUGIA_KEY = "HalloweenLugia";

    @SubscribeEvent
    public static void onCapture(CaptureEvent.StartCapture event) {
        if (event.getPlayer() == null) {
            return;
        }
        if (DrownedWorld.is((World)event.getPlayer().func_71121_q()) && event.getPokemon().getPalette().is("drowned") && !EntityHelper.getPersistentData((PlayerEntity)event.getPlayer()).func_74767_n(DROWNED_LUGIA_KEY)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        ServerPlayerEntity player;
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof ServerPlayerEntity && DrownedWorld.is((World)(player = (ServerPlayerEntity)entity).func_71121_q())) {
            if (entity.func_226278_cu_() <= 10.0) {
                DrownedWorldListener.teleportOut(player);
            } else if (entity.func_226278_cu_() >= 246.0) {
                DrownedWorldListener.teleportOut(player);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        ServerPlayerEntity player;
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof ServerPlayerEntity && DrownedWorld.is((World)(player = (ServerPlayerEntity)entity).func_71121_q()) && event.getSource().field_76373_n.equalsIgnoreCase(DamageSource.field_76369_e.field_76373_n) && entity.func_110143_aJ() <= 2.0f) {
            event.setCanceled(true);
            DrownedWorldListener.teleportOut(player);
        }
    }

    private static void teleportOut(ServerPlayerEntity player) {
        player.func_70050_g(player.func_205010_bg());
        player.func_70691_i(player.func_110138_aP());
        BlockPos respawnPosition = player.func_241140_K_();
        ServerWorld world = ServerLifecycleHooks.getCurrentServer().func_71218_a(player.func_241141_L_());
        if (respawnPosition == null) {
            respawnPosition = world.func_241135_u_();
        }
        player.func_200619_a(world, (double)respawnPosition.func_177958_n(), (double)respawnPosition.func_177956_o(), (double)respawnPosition.func_177952_p(), player.field_70177_z, player.field_70125_A);
    }
}

