/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.listener;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.SpawnLocationHelper;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class VillageListener {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onCreateSpawnPosition(WorldEvent.CreateSpawnPosition event) {
        if (VillageListener.setVillageSpawnPoint((ServerWorld)event.getWorld(), event.getSettings())) {
            event.setCanceled(true);
        }
    }

    private static boolean setVillageSpawnPoint(ServerWorld world, IServerWorldInfo worldInfo) {
        if (PixelmonConfigProxy.getStructures().shouldAlwaysSpawnInVillage()) {
            BlockPos villageblockpos;
            ChunkPos chunkpos;
            boolean bonusChest = ServerLifecycleHooks.getCurrentServer().func_240793_aU_().func_230418_z_().func_236223_d_();
            ChunkGenerator chunkgenerator = world.func_72863_F().func_201711_g();
            BiomeProvider biomeprovider = chunkgenerator.func_202090_b();
            Random random = new Random(world.func_72905_C());
            BlockPos blockpos = biomeprovider.func_225531_a_(0, world.func_181545_F(), 0, 256, biome -> biome.func_242433_b().func_242562_b(), random);
            ChunkPos chunkPos = chunkpos = blockpos == null ? new ChunkPos(0, 0) : new ChunkPos(blockpos);
            if (blockpos == null) {
                Pixelmon.LOGGER.warn("Unable to find spawn biome");
            }
            if ((villageblockpos = world.func_241117_a_(Structure.field_236381_q_, chunkpos.func_206849_h().func_177982_a(0, world.func_181545_F(), 0), 100, false)) == null) {
                Pixelmon.LOGGER.warn("Unable to find spawn village");
            } else {
                chunkpos = new ChunkPos(villageblockpos);
            }
            boolean flag = false;
            for (Block block : BlockTags.field_205599_H.func_230236_b_()) {
                if (!biomeprovider.func_205706_b().contains(block.func_176223_P())) continue;
                flag = true;
                break;
            }
            worldInfo.func_176143_a(chunkpos.func_206849_h().func_177982_a(8, chunkgenerator.func_205470_d(), 8), 0.0f);
            int i1 = 0;
            int j1 = 0;
            int i = 0;
            int j = -1;
            int k = 32;
            for (int l = 0; l < 1024; ++l) {
                BlockPos blockpos1;
                if (i1 > -16 && i1 <= 16 && j1 > -16 && j1 <= 16 && (blockpos1 = SpawnLocationHelper.func_241094_a_((ServerWorld)world, (ChunkPos)new ChunkPos(chunkpos.field_77276_a + i1, chunkpos.field_77275_b + j1), (boolean)flag)) != null) {
                    worldInfo.func_176143_a(blockpos1, 0.0f);
                    break;
                }
                if (i1 == j1 || i1 < 0 && i1 == -j1 || i1 > 0 && i1 == 1 - j1) {
                    int k1 = i;
                    i = -j;
                    j = k1;
                }
                i1 += i;
                j1 += j;
            }
            if (bonusChest) {
                ConfiguredFeature configuredfeature = Features.field_243795_U;
                configuredfeature.func_242765_a((ISeedReader)world, chunkgenerator, world.field_73012_v, new BlockPos(worldInfo.func_76079_c(), worldInfo.func_76075_d(), worldInfo.func_76074_e()));
            }
            return true;
        }
        return false;
    }
}

