/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.blocks.ScrollBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.ScrollTileEntity;
import com.pixelmonmod.pixelmon.client.models.items.PixelmonISTERs;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.WallSignBlock;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class ScrollItem
extends PixelmonItem {
    public final ScrollBlock.Type type;

    public ScrollItem(ScrollBlock.Type type) {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78031_c).func_200917_a(1).setISTER(() -> PixelmonISTERs.SCROLL_ISTER));
        this.type = type;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        Hand hand = context.func_221531_n();
        BlockState iblockstate = worldIn.func_180495_p(pos);
        boolean flag = iblockstate.func_177230_c().func_196253_a(worldIn.func_180495_p(pos), new BlockItemUseContext(context));
        if (!(facing == Direction.DOWN || !iblockstate.func_185904_a().func_76220_a() && !flag || flag && facing != Direction.UP)) {
            pos = pos.func_177972_a(facing);
            ItemStack itemstack = player.func_184586_b(hand);
            CompoundNBT tag = itemstack.func_190925_c("BlockEntityTag");
            tag.func_74774_a("Type", (byte)this.type.ordinal());
            if (player.func_175151_a(pos, facing, itemstack) && PixelmonBlocks.standing_scroll.canPlaceBlockAt(worldIn, pos)) {
                if (!worldIn.field_72995_K) {
                    BlockPos blockPos = pos = flag ? pos.func_177977_b() : pos;
                    if (worldIn.func_175623_d(pos)) {
                        if (facing == Direction.UP) {
                            int i = MathHelper.func_76128_c((double)((double)((player.field_70177_z + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF;
                            worldIn.func_180501_a(pos, (BlockState)PixelmonBlocks.standing_scroll.func_176223_P().func_206870_a((Property)StandingSignBlock.field_176413_a, (Comparable)Integer.valueOf(i)), 3);
                        } else {
                            worldIn.func_180501_a(pos, (BlockState)PixelmonBlocks.hanging_scroll.func_176223_P().func_206870_a((Property)WallSignBlock.field_176412_a, (Comparable)facing), 3);
                        }
                        TileEntity tileentity = worldIn.func_175625_s(pos);
                        if (tileentity instanceof ScrollTileEntity) {
                            ScrollTileEntity scroll = (ScrollTileEntity)tileentity;
                            scroll.setItemValues(itemstack);
                            if (player instanceof ServerPlayerEntity) {
                                ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
                                CriteriaTriggers.field_193137_x.func_193173_a(playerMP, pos, itemstack);
                            }
                        }
                        worldIn.func_184138_a(pos, iblockstate, iblockstate, 2);
                        itemstack.func_190918_g(1);
                    } else {
                        return ActionResultType.FAIL;
                    }
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.FAIL;
    }

    public String getItemStackDisplayName(ItemStack stack) {
        return I18n.func_135052_a((String)("item." + this.type.getName() + ""), (Object[])new Object[0]);
    }

    public static ItemStack makeScroll(ScrollBlock.Type type, boolean displayOnly, @Nullable String resourceLocation) {
        ItemStack itemstack = new ItemStack((IItemProvider)(type == ScrollBlock.Type.WATERS ? PixelmonItems.scroll_of_waters : PixelmonItems.scroll_of_darkness), 1);
        CompoundNBT tag = itemstack.func_190925_c("BlockEntityTag");
        tag.func_74778_a("Resource", resourceLocation == null ? type.getDefaultResource() : resourceLocation);
        tag.func_74774_a("Type", (byte)type.ordinal());
        tag.func_74757_a("DisplayOnly", displayOnly);
        return itemstack;
    }

    public ItemGroup getCreativeTab() {
        return ItemGroup.field_78031_c;
    }
}

