/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.items;

import com.pixelmonmod.pixelmon.api.pokemon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.enums.EnumBerryFlavor;
import com.pixelmonmod.pixelmon.enums.EnumCurryKey;
import com.pixelmonmod.pixelmon.enums.EnumCurryRating;
import com.pixelmonmod.pixelmon.items.PixelmonItem;
import com.pixelmonmod.pixelmon.items.group.PixelmonItemGroups;
import com.pixelmonmod.pixelmon.items.medicine.MedicineStatus;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CurryDishItem
extends PixelmonItem {
    private static final MedicineStatus allStatuses = new MedicineStatus(StatusType.Burn, StatusType.Confusion, StatusType.Freeze, StatusType.Paralysis, StatusType.Poison, StatusType.PoisonBadly, StatusType.Sleep, StatusType.Infatuated);

    public CurryDishItem(EnumCurryKey key) {
        super(new Item.Properties().func_200916_a(PixelmonItemGroups.TAB_RESTORATION));
    }

    public String getItemStackDisplayName(ItemStack stack) {
        EnumBerryFlavor flavor = EnumBerryFlavor.NONE;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("BerryFlavor")) {
            flavor = EnumBerryFlavor.values()[stack.func_77978_p().func_74771_c("BerryFlavor")];
        }
        return I18n.func_135052_a((String)(this.func_77658_a() + ""), (Object[])new Object[]{I18n.func_135052_a((String)("berry.flavor." + flavor.name().toLowerCase(Locale.ROOT) + ""), (Object[])new Object[0])}).trim();
    }

    public boolean useCurry(ItemStack stack, PokemonLink pokemon) {
        EnumCurryRating rating = EnumCurryRating.KOFFING;
        if (stack.func_77942_o() && stack.func_77978_p().func_74765_d("CurryQuality") != 0) {
            rating = EnumCurryRating.values()[stack.func_77978_p().func_74771_c("CurryQuality")];
        }
        pokemon.sendMessage("item.pixelmon.curry.used", stack.func_200301_q(), pokemon.getNickname());
        int currentHealth = pokemon.getHealth();
        int maxHealth = pokemon.getMaxHealth();
        if (currentHealth < maxHealth) {
            pokemon.setHealth((int)Math.min((double)maxHealth, (double)currentHealth + (double)maxHealth * rating.hpHeal));
            pokemon.update(EnumUpdateType.HP);
        }
        pokemon.adjustFriendship(rating.happinessBoost);
        pokemon.getPokemon().getPokemonLevelContainer().awardEXP(rating.expBoost, rating.getGainType());
        if (rating.ppRestore) {
            for (int i = 0; i < pokemon.getMoveset().size(); ++i) {
                pokemon.getMoveset().get((int)i).pp = pokemon.getMoveset().get(i).getMaxPP();
            }
        }
        if (rating.statusCure) {
            PixelmonItems.full_heal.useMedicine(pokemon, 0);
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        CompoundNBT nbt = stack.func_77978_p();
        int rating = 0;
        if (nbt != null && nbt.func_74764_b("CurryQuality")) {
            rating = nbt.func_74765_d("CurryQuality");
        }
        TextFormatting color = TextFormatting.DARK_PURPLE;
        switch (rating) {
            case 1: {
                color = TextFormatting.BLUE;
                break;
            }
            case 2: {
                color = TextFormatting.DARK_RED;
                break;
            }
            case 3: {
                color = TextFormatting.GRAY;
                break;
            }
            case 4: {
                color = TextFormatting.GOLD;
            }
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("item.pixelmon.curry.tooltip", new Object[]{EnumCurryRating.values()[rating].getLocalizedName()}).func_240699_a_(color));
        super.func_77624_a(stack, world, tooltip, advanced);
    }
}

