/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.items;

import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.items.ApricornItem;
import com.pixelmonmod.pixelmon.items.CookedApricornItem;
import com.pixelmonmod.pixelmon.world.generation.PixelmonFeatures;
import net.minecraft.block.Block;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;

public enum ApricornType {
    BLACK(72, 88, 5),
    WHITE(73, 89, 5),
    PINK(74, 90, 5),
    GREEN(75, 91, 5),
    BLUE(76, 92, 5),
    YELLOW(77, 93, 5),
    RED(78, 94, 5);

    private final int iconIndex;
    private final int meltedIconIndex;
    private final int growthTime;

    private ApricornType(int iconIndex, int meltedIconIndex, int growthTime) {
        this.iconIndex = iconIndex;
        this.meltedIconIndex = meltedIconIndex;
        this.growthTime = growthTime;
    }

    public int getIconIndex() {
        return this.iconIndex;
    }

    public int getMeltedIconIndex() {
        return this.meltedIconIndex;
    }

    public ApricornItem apricorn() {
        switch (this) {
            case BLACK: {
                return PixelmonItems.black_apricorn;
            }
            case BLUE: {
                return PixelmonItems.blue_apricorn;
            }
            case GREEN: {
                return PixelmonItems.green_apricorn;
            }
            case PINK: {
                return PixelmonItems.pink_apricorn;
            }
            case RED: {
                return PixelmonItems.red_apricorn;
            }
            case WHITE: {
                return PixelmonItems.white_apricorn;
            }
            case YELLOW: {
                return PixelmonItems.yellow_apricorn;
            }
        }
        return null;
    }

    public CookedApricornItem cookedApricorn() {
        switch (this) {
            case BLACK: {
                return PixelmonItems.cooked_black_apricorn;
            }
            case BLUE: {
                return PixelmonItems.cooked_blue_apricorn;
            }
            case GREEN: {
                return PixelmonItems.cooked_green_apricorn;
            }
            case PINK: {
                return PixelmonItems.cooked_pink_apricorn;
            }
            case RED: {
                return PixelmonItems.cooked_red_apricorn;
            }
            case WHITE: {
                return PixelmonItems.cooked_white_apricorn;
            }
            case YELLOW: {
                return PixelmonItems.cooked_yellow_apricorn;
            }
        }
        return null;
    }

    public Block logBlock() {
        return PixelmonBlocks.apricorn_log;
    }

    public Block leavesBlock() {
        switch (this) {
            case BLACK: {
                return PixelmonBlocks.apricorn_leaves_black;
            }
            case BLUE: {
                return PixelmonBlocks.apricorn_leaves_blue;
            }
            case GREEN: {
                return PixelmonBlocks.apricorn_leaves_green;
            }
            case PINK: {
                return PixelmonBlocks.apricorn_leaves_pink;
            }
            case RED: {
                return PixelmonBlocks.apricorn_leaves_red;
            }
            case WHITE: {
                return PixelmonBlocks.apricorn_leaves_white;
            }
            case YELLOW: {
                return PixelmonBlocks.apricorn_leaves_yellow;
            }
        }
        return null;
    }

    public Block saplingBlock() {
        switch (this) {
            case BLACK: {
                return PixelmonBlocks.apricorn_plant_black;
            }
            case BLUE: {
                return PixelmonBlocks.apricorn_plant_blue;
            }
            case GREEN: {
                return PixelmonBlocks.apricorn_plant_green;
            }
            case PINK: {
                return PixelmonBlocks.apricorn_plant_pink;
            }
            case RED: {
                return PixelmonBlocks.apricorn_plant_red;
            }
            case WHITE: {
                return PixelmonBlocks.apricorn_plant_white;
            }
            case YELLOW: {
                return PixelmonBlocks.apricorn_plant_yellow;
            }
        }
        return null;
    }

    public ConfiguredFeature<BaseTreeFeatureConfig, ?> getFeature() {
        switch (this) {
            case BLACK: {
                return PixelmonFeatures.BLACK_APRICORN_TREE;
            }
            case BLUE: {
                return PixelmonFeatures.BLUE_APRICORN_TREE;
            }
            case GREEN: {
                return PixelmonFeatures.GREEN_APRICORN_TREE;
            }
            case PINK: {
                return PixelmonFeatures.PINK_APRICORN_TREE;
            }
            case RED: {
                return PixelmonFeatures.RED_APRICORN_TREE;
            }
            case WHITE: {
                return PixelmonFeatures.WHITE_APRICORN_TREE;
            }
            case YELLOW: {
                return PixelmonFeatures.YELLOW_APRICORN_TREE;
            }
        }
        return null;
    }

    public int getGrowthTime() {
        return this.growthTime;
    }

    public static boolean hasApricorn(String apricorn) {
        try {
            return ApricornType.valueOf(apricorn) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

