/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.interactions.formChanges;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.pokemon.ItemFormChangeEvent;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.registries.PixelmonForms;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.formChanges.IFormChange;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.eventbus.api.Event;

public class CalyrexFormChange
implements IFormChange {
    private static final String[] RIDER_MOVES = new String[]{"Glacial Lance", "Astral Barrage", "Tackle", "Tail Whip", "Double Kick", "Avalanche", "Hex", "Stomp", "Torment", "Confuse Ray", "Mist", "Haze", "Icicle Crash", "Shadow Ball", "Take Down", "Iron Defense", "Agility", "Thrash", "Taunt", "Disable", "Double-Edge", "Swords Dance", "Nasty Plot"};

    @Override
    public boolean isValidItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == PixelmonItems.reins_of_unity;
    }

    @Override
    public boolean isValidPokemon(PixelmonEntity pixelmon) {
        return pixelmon.isPokemon(PixelmonSpecies.CALYREX.getValueUnsafe()) && !pixelmon.isEvolving();
    }

    @Override
    public boolean execute(PixelmonEntity pixelmon, ItemStack stack, ServerPlayerEntity player) {
        PlayerPartyStorage storage = StorageProxy.getParty(player);
        if (!pixelmon.getForm().isForm(PixelmonForms.NONE)) {
            ItemFormChangeEvent event;
            CompoundNBT fusedPokemonNBT = pixelmon.getPokemon().getPersistentData().func_74775_l("FusedPokemon");
            Pokemon fused = null;
            if (!fusedPokemonNBT.isEmpty()) {
                try {
                    fused = PokemonFactory.create(fusedPokemonNBT);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (fused == null) {
                    Pixelmon.LOGGER.error("Couldn't get fused Pok\u00e9mon from NBT for player: " + player.func_200200_C_());
                }
            }
            if (Pixelmon.EVENT_BUS.post((Event)(event = new ItemFormChangeEvent(player, stack, pixelmon, fused)))) {
                return false;
            }
            if (fused != null) {
                storage.add(event.fusion);
            }
            pixelmon.getPersistentData().func_82580_o("FusedPokemon");
            pixelmon.func_130014_f_().func_184148_a(null, pixelmon.func_226277_ct_(), pixelmon.func_226278_cu_(), pixelmon.func_226281_cx_(), SoundEvents.field_187726_cu, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            Moveset moveset = pixelmon.getPokemon().getMoveset();
            moveset.removeAttack(AttackRegistry.GLACIAL_LANCE, AttackRegistry.ASTRAL_BARRAGE, AttackRegistry.TACKLE, AttackRegistry.TAIL_WHIP, AttackRegistry.DOUBLE_KICK, AttackRegistry.AVALANCHE, AttackRegistry.HEX, AttackRegistry.STOMP, AttackRegistry.TORMENT, AttackRegistry.CONFUSE_RAY, AttackRegistry.MIST, AttackRegistry.HAZE, AttackRegistry.ICICLE_CRASH, AttackRegistry.SHADOW_BALL, AttackRegistry.TAKE_DOWN, AttackRegistry.IRON_DEFENSE, AttackRegistry.AGILITY, AttackRegistry.THRASH, AttackRegistry.TAUNT, AttackRegistry.DISABLE, AttackRegistry.DOUBLE_EDGE, AttackRegistry.SWORDS_DANCE, AttackRegistry.NASTY_PLOT);
            if (moveset.isEmpty()) {
                moveset.add(new Attack(AttackRegistry.CONFUSION));
            }
            pixelmon.getPokemon().setForm(PixelmonForms.NONE);
        } else {
            Attack specialMove;
            Pokemon pokemon = storage.findOne(p -> !p.isEgg() && p.isPokemonOptional(PixelmonSpecies.GLASTRIER, PixelmonSpecies.SPECTRIER));
            if (pokemon == null) {
                ChatHandler.sendFormattedChat((ICommandSource)player, TextFormatting.RED, "pixelmon.interaction.calyrex.notfound", pixelmon.func_145748_c_());
                return true;
            }
            ItemFormChangeEvent event = new ItemFormChangeEvent(player, stack, pixelmon, pokemon);
            if (Pixelmon.EVENT_BUS.post((Event)event)) {
                return false;
            }
            pixelmon.func_130014_f_().func_184148_a(null, pixelmon.func_226277_ct_(), pixelmon.func_226278_cu_(), pixelmon.func_226281_cx_(), SoundEvents.field_187699_cl, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            pokemon.ifEntityExists(pixelmonEntity -> pixelmonEntity.retrieve("FormChange"));
            storage.set((StoragePosition)pokemon.getStorageAndPosition().func_76340_b(), null);
            CompoundNBT pokenbt = new CompoundNBT();
            pokemon.writeToNBT(pokenbt);
            pixelmon.getPokemon().getPersistentData().func_218657_a("FusedPokemon", (INBT)pokenbt);
            pixelmon.setForm(pokemon.getSpecies().is(PixelmonSpecies.GLASTRIER) ? "icerider" : "shadowrider");
            Attack attack = specialMove = pokemon.getSpecies().is(PixelmonSpecies.GLASTRIER) ? new Attack(AttackRegistry.GLACIAL_LANCE) : new Attack(AttackRegistry.ASTRAL_BARRAGE);
            if (!pixelmon.getPokemon().getMoveset().add(specialMove)) {
                LearnMoveController.sendLearnMove(player, pixelmon.getPokemon().getUUID(), specialMove.getActualMove());
            }
        }
        return true;
    }
}

