/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs.registry;

import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseShopItem;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ShopItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;

public class ShopItemWithVariation {
    private float variation;
    private ShopItem shopItem;

    public ShopItemWithVariation(ShopItem shopItem, float variation) {
        this.shopItem = shopItem;
        this.variation = variation;
    }

    public ShopItemWithVariation(ShopItem item) {
        this(item, item.canPriceVary() ? ShopItemWithVariation.getVariation() : 1.0f);
    }

    private static float getVariation() {
        float rand = RandomHelper.getRandomNumberBetween(0.0f, 1.0f);
        float variation = 1.0f;
        if ((double)rand > 0.75) {
            variation = 1.1f;
        } else if ((double)rand < 0.25) {
            variation = 0.9f;
        }
        return variation;
    }

    public void writeToNBT(ListNBT list) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("ItemName", this.shopItem.getBaseItem().id);
        tag.func_74776_a("ItemVar", this.variation);
        list.add((Object)tag);
    }

    public static ShopItemWithVariation getFromNBT(String npcIndex, CompoundNBT tag) {
        ShopItem item = ServerNPCRegistry.shopkeepers.getItem(npcIndex, tag.func_74779_i("ItemName"));
        if (item == null) {
            return null;
        }
        return new ShopItemWithVariation(item, tag.func_74760_g("ItemVar"));
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.func_180714_a(this.shopItem.getBaseItem().id);
        buffer.func_150788_a(this.shopItem.getBaseItem().itemStack);
        buffer.writeInt((int)((float)this.getBaseShopItem().buy * this.shopItem.getBuyMultiplier() * this.variation));
        buffer.writeInt((int)((float)this.getBaseShopItem().sell * this.variation));
    }

    public ItemStack getItemStack() {
        return this.shopItem.getItemStack();
    }

    public BaseShopItem getBaseShopItem() {
        return this.shopItem.getBaseItem();
    }

    public boolean canSell() {
        return this.shopItem.getBaseItem().sell != -1;
    }

    public int getBuyCost() {
        return (int)Math.max(0.0f, (float)this.getBaseShopItem().buy * this.shopItem.getBuyMultiplier() * this.variation);
    }

    public int getSellCost() {
        return (int)((float)this.getBaseShopItem().sell * this.variation);
    }
}

