/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;

public class MoveListCommand
extends PixelCommand {
    public MoveListCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "movelist", "/movelist <pokemon>", 2);
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        Optional<Species> s;
        if (args.length != 1) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        if (!(s = PixelmonSpecies.fromNameOrDex(args[0])).isPresent()) {
            PixelmonCommandUtils.endCommand("pixelmon.command.movelist.pokemonnotfound", args[0]);
        }
        Pokemon pokemon = PokemonFactory.create(s.get());
        List attackNames = pokemon.getForm().getMoves().getAllMoves().stream().map(ImmutableAttack::getAttackName).collect(Collectors.toList());
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GREEN, "pixelmon.command.movelist.header", pokemon.getLocalizedName()), false);
        CommandChatHandler.sendFormattedChat(sender, TextFormatting.GREEN, StringUtils.join(attackNames, (String)(TextFormatting.GREEN + ", ")), new Object[0]);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        if (args.length == 1) {
            return PixelmonCommandUtils.tabCompletePokemon();
        }
        return super.getTabCompletions(server, sender, args, pos);
    }
}

