/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PCStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.command.PixelCommand;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class CompEditCommand
extends PixelCommand {
    private static final List<String> ALIASES = Lists.newArrayList((Object[])new String[]{"pcedit", "cedit"});

    public CompEditCommand(CommandDispatcher<CommandSource> dispatcher) {
        super(dispatcher, "compedit", "/compedit [player] <box> <slot> <specs...>", 2);
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public void execute(CommandSource sender, String[] args) throws CommandException, CommandSyntaxException {
        if ((args = PixelmonCommandUtils.setupCommandTargets(this, sender, args, 0)).length < 4) {
            sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]), false);
            PixelmonCommandUtils.endCommand(this.getUsage(sender), new Object[0]);
        }
        ServerPlayerEntity player = PixelmonCommandUtils.requireEntityPlayer(args[0]);
        PCStorage storage = PixelmonCommandUtils.require(PixelmonCommandUtils.getComputerStorage(player), "pixelmon.command.general.invalidplayer", new Object[0]);
        int box = PixelmonCommandUtils.requireInt(args[1], 1, PixelmonConfigProxy.getStorage().getComputerBoxes(), "pixelmon.command.box", PixelmonConfigProxy.getStorage().getComputerBoxes());
        int slot = PixelmonCommandUtils.requireInt(args[2], 1, 30, "pixelmon.command.slot", 30);
        StoragePosition storagePosition = new StoragePosition(box - 1, slot - 1);
        Pokemon pokemon = PixelmonCommandUtils.require(storage.get(storagePosition), "pixelmon.command.compslot.nothing", player.func_200200_C_());
        String[] specList = Arrays.copyOfRange(args, 3, args.length);
        PixelmonCommandUtils.applySpecs(pokemon, specList);
        sender.func_197030_a((ITextComponent)PixelmonCommandUtils.format(TextFormatting.GRAY, "pixelmon.command.compedit.edited", pokemon.getLocalizedName()), false);
    }

    @Override
    public List<String> getTabCompletions(MinecraftServer server, CommandSource sender, String[] args, BlockPos pos) throws CommandSyntaxException {
        boolean hasPermissionOtherTarget = this.hasPermissionOtherTarget(sender);
        switch (args.length) {
            case 0: {
                return super.getTabCompletions(server, sender, args, pos);
            }
            case 1: {
                if (hasPermissionOtherTarget) {
                    return PixelmonCommandUtils.tabCompleteUsernames();
                }
                return IntStream.range(1, PixelmonConfigProxy.getStorage().getComputerBoxes()).mapToObj(String::valueOf).collect(Collectors.toList());
            }
            case 2: {
                if (hasPermissionOtherTarget) {
                    return IntStream.range(1, PixelmonConfigProxy.getStorage().getComputerBoxes()).mapToObj(String::valueOf).collect(Collectors.toList());
                }
                return IntStream.range(1, 30).mapToObj(String::valueOf).collect(Collectors.toList());
            }
            case 3: {
                if (!hasPermissionOtherTarget) break;
                return IntStream.range(1, 30).mapToObj(String::valueOf).collect(Collectors.toList());
            }
        }
        return PixelmonCommandUtils.SPEC_REQUIREMENTS;
    }
}

