/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.zygarde;

import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.ReassemblyUnitTileEntity;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class ZygardeReassemblyPacket
extends AbstractPixelmonPacket {
    private BlockPos pos;
    private ReassemblyUnitTileEntity.Mode mode;
    private StoragePosition position;
    private int slot;

    public ZygardeReassemblyPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public ZygardeReassemblyPacket(BlockPos pos, ReassemblyUnitTileEntity.Mode mode, StoragePosition position, int slot) {
        super(PacketDirection.PLAY_SERVER, true);
        this.pos = pos;
        this.mode = mode;
        this.position = position;
        this.slot = slot;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.pos = BlockPos.func_218283_e((long)buf.readLong());
        this.mode = ReassemblyUnitTileEntity.Mode.fromOrdinal(buf.readByte());
        this.position = buf.readBoolean() ? StoragePosition.decode((ByteBuf)buf) : null;
        this.slot = buf.readInt();
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeLong(this.pos.func_218275_a());
        buf.writeByte(this.mode.ordinal());
        buf.writeBoolean(this.position != null);
        if (this.position != null) {
            this.position.encode((ByteBuf)buf);
        }
        buf.writeInt(this.slot);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        World world = context.getSender().field_70170_p;
        ReassemblyUnitTileEntity assembly = BlockHelper.getTileEntity(ReassemblyUnitTileEntity.class, (IBlockReader)world, this.pos);
        if (assembly != null) {
            assembly.onSelection(context.getSender(), this.mode, this.position, this.slot);
        }
    }
}

