/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor;

import com.pixelmonmod.pixelmon.api.util.helpers.DimensionHelper;
import com.pixelmonmod.pixelmon.blocks.tileentity.PokeDisplayTileEntity;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.EnumStatuePacketMode;
import com.pixelmonmod.pixelmon.enums.EnumStatueTextureType;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class PokeDisplayUpdatePacket
extends AbstractPixelmonPacket {
    private EnumStatuePacketMode mode;
    private PokeDisplayTileEntity id;
    private String name;
    private boolean data;
    private int intData;

    public PokeDisplayUpdatePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public PokeDisplayUpdatePacket(EnumStatuePacketMode mode, PokeDisplayTileEntity id, String name) {
        super(PacketDirection.PLAY_SERVER, true);
        this.mode = mode;
        this.id = id;
        this.name = name;
    }

    public PokeDisplayUpdatePacket(EnumStatuePacketMode mode, PokeDisplayTileEntity id, boolean data) {
        super(PacketDirection.PLAY_SERVER, true);
        this.mode = mode;
        this.id = id;
        this.data = data;
    }

    public PokeDisplayUpdatePacket(EnumStatuePacketMode mode, PokeDisplayTileEntity id, int intData) {
        super(PacketDirection.PLAY_SERVER, true);
        this.mode = mode;
        this.id = id;
        this.intData = intData;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.mode = EnumStatuePacketMode.getFromOrdinal(buf.readShort());
        ServerWorld world = ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionHelper.getDimension(buf.func_192575_l()));
        this.id = (PokeDisplayTileEntity)world.func_175625_s(buf.func_179259_c());
        switch (this.mode) {
            case SetGrowth: 
            case SetLabel: 
            case SetTextureType: 
            case SetAnimation: 
            case SetName: 
            case SetPalette: 
            case SetBoundingBoxMode: 
            case SetForm: {
                this.name = buf.func_218666_n();
                break;
            }
            case SetShouldAnimate: 
            case SetModelStanding: 
            case SetCanMove: {
                this.data = buf.readBoolean();
                break;
            }
            case SetAnimationFrame: 
            case SetGender: 
            case SET_SPECIES: {
                this.intData = buf.readInt();
            }
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeShort((int)((short)this.mode.ordinal()));
        buf.func_192572_a(this.id.func_145831_w().func_234923_W_().func_240901_a_());
        buf.func_179255_a(this.id.func_174877_v());
        switch (this.mode) {
            case SetGrowth: 
            case SetLabel: 
            case SetTextureType: 
            case SetAnimation: 
            case SetName: 
            case SetPalette: 
            case SetBoundingBoxMode: 
            case SetForm: {
                buf.func_180714_a(this.name);
                break;
            }
            case SetShouldAnimate: 
            case SetModelStanding: 
            case SetCanMove: {
                buf.writeBoolean(this.data);
                break;
            }
            case SetAnimationFrame: 
            case SetGender: 
            case SET_SPECIES: {
                buf.writeInt(this.intData);
            }
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity sender = context.getSender();
        Object value = this.mode.chooseValueForMode(this.name, this.data, this.intData);
        switch (this.mode) {
            case SetLabel: {
                this.id.setLabel((String)value);
                break;
            }
            case SetTextureType: {
                this.id.setTextureMode(EnumStatueTextureType.getFromString((String)value));
                break;
            }
            case SetAnimation: {
                this.id.setAnimation(AnimationType.getTypeFor((String)value));
                break;
            }
            case SetModelStanding: {
                this.id.setFlying((Boolean)value);
                break;
            }
            case SetAnimationFrame: {
                this.id.setAnimationFrame((Integer)value);
                break;
            }
            case SetForm: {
                this.id.getStoredEntity().setForm((String)value);
                break;
            }
            case SetShouldAnimate: {
                this.id.setAnimate((Boolean)value);
            }
        }
        this.id.func_70296_d();
    }
}

