/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.comm.SetTrainerData;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.EnumStoreTrainerDataType;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.items.NPCEditorItem;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class StoreTrainerDataPacket
extends AbstractPixelmonPacket {
    private int trainerId;
    private SetTrainerData data;
    private ItemStack[] drops;
    private EnumStoreTrainerDataType dataType;

    public StoreTrainerDataPacket() {
        super(PacketDirection.PLAY_SERVER);
    }

    public StoreTrainerDataPacket(int trainerId, SetTrainerData data) {
        super(PacketDirection.PLAY_SERVER);
        this.trainerId = trainerId;
        this.data = data;
        this.dataType = EnumStoreTrainerDataType.CHAT;
    }

    public StoreTrainerDataPacket(int currentTrainerID, ItemStack ... drops) {
        super(PacketDirection.PLAY_SERVER);
        this.trainerId = currentTrainerID;
        this.drops = drops;
        this.dataType = EnumStoreTrainerDataType.DROPS;
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.trainerId = buf.readInt();
        this.dataType = EnumStoreTrainerDataType.values()[buf.readInt()];
        if (this.dataType == EnumStoreTrainerDataType.CHAT) {
            this.data = new SetTrainerData();
            this.data.decodeInto(buf);
        } else {
            this.drops = new ItemStack[buf.readInt()];
            for (int i = 0; i < this.drops.length; ++i) {
                this.drops[i] = buf.func_150791_c();
            }
        }
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.trainerId);
        buf.writeInt(this.dataType.ordinal());
        if (this.dataType == EnumStoreTrainerDataType.CHAT) {
            this.data.encodeInto(buf);
        } else {
            buf.writeInt(this.drops.length);
            for (ItemStack stack : this.drops) {
                buf.func_150788_a(stack);
            }
        }
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (!NPCEditorItem.checkPermission((PlayerEntity)player)) {
            return;
        }
        Optional<NPCTrainer> entityNPCOptional = NPCEntity.locateNPCServer(player.field_70170_p, this.trainerId, NPCTrainer.class);
        if (!entityNPCOptional.isPresent()) {
            return;
        }
        NPCTrainer trainer = entityNPCOptional.get();
        if (this.dataType == EnumStoreTrainerDataType.CHAT) {
            trainer.update(this.data);
        } else {
            trainer.updateDrops(this.drops);
        }
    }
}

