/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.itemDrops;

import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.ServerStorageDisplay;
import com.pixelmonmod.pixelmon.client.gui.ItemDropsScreen;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BattleGuiClosedPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.itemDrops.ItemDropMode;
import com.pixelmonmod.pixelmon.comm.packetHandlers.itemDrops.ServerItemDropPacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.drops.DroppedItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_CLIENT})
public class ItemDropPacket
extends AbstractPixelmonPacket {
    public DroppedItem[] items;
    public boolean hasCustomTitle = false;
    public ItemDropMode mode;
    public TranslationTextComponent customTitle;

    public ItemDropPacket() {
        super(PacketDirection.PLAY_CLIENT, true);
    }

    public ItemDropPacket(ItemDropMode mode, List<DroppedItem> givenDrops) {
        super(PacketDirection.PLAY_CLIENT, true);
        this.items = givenDrops.toArray(new DroppedItem[0]);
        this.mode = mode;
    }

    public ItemDropPacket(ItemDropMode mode, TranslationTextComponent customTitle, List<DroppedItem> drops) {
        this(mode, drops);
        this.hasCustomTitle = true;
        this.customTitle = customTitle;
    }

    public ItemDropPacket(TranslationTextComponent customTitle, ArrayList<DroppedItem> drops) {
        this(ItemDropMode.Other, customTitle, drops);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.mode = ItemDropMode.values()[buffer.readInt()];
        this.items = new DroppedItem[buffer.readShort()];
        this.hasCustomTitle = buffer.readBoolean();
        int actualLength = this.items.length;
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = DroppedItem.fromBytes(buffer);
            if (this.items[i] != null) continue;
            --actualLength;
        }
        if (actualLength != this.items.length) {
            DroppedItem[] newItems = new DroppedItem[actualLength];
            int newItemIndex = 0;
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null || newItemIndex >= actualLength) continue;
                newItems[newItemIndex++] = this.items[i];
            }
            this.items = newItems;
        }
        if (this.hasCustomTitle) {
            try {
                this.customTitle = (TranslationTextComponent)ITextComponent.Serializer.func_240643_a_((String)buffer.func_150789_c(Short.MAX_VALUE));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.mode.ordinal());
        buffer.writeShort(this.items.length);
        buffer.writeBoolean(this.hasCustomTitle);
        for (DroppedItem item : this.items) {
            item.toBytes(buffer);
        }
        if (this.hasCustomTitle) {
            try {
                buffer.func_180714_a(ITextComponent.Serializer.func_150696_a((ITextComponent)this.customTitle));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void handlePacket(NetworkEvent.Context context) {
        if (PixelmonConfigProxy.getGeneral().getDrops().isUseDropGUI() || this.mode != ItemDropMode.NormalPokemon) {
            ServerStorageDisplay.bossDrops = this;
            if (ClientProxy.battleManager.battleEnded && !ClientProxy.battleManager.hasMoreMessages()) {
                Minecraft.func_71410_x().func_147108_a((Screen)new ItemDropsScreen());
            }
        } else {
            NetworkHelper.sendToServer(new ServerItemDropPacket(ServerItemDropPacket.PacketMode.TakeAllItems));
            NetworkHelper.sendToServer(new BattleGuiClosedPacket());
        }
    }
}

