/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.items.ReviveItem;
import java.util.UUID;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class UseRevivePacket
extends AbstractPixelmonPacket {
    private UUID pokemonUUID;

    public UseRevivePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public UseRevivePacket(UUID pokemonUUID) {
        super(PacketDirection.PLAY_SERVER, true);
        this.pokemonUUID = pokemonUUID;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179252_a(this.pokemonUUID);
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        ItemStack itemStack = player.func_184614_ca();
        Item item = itemStack.func_77973_b();
        if (!(item instanceof ReviveItem)) {
            return;
        }
        ReviveItem revive = (ReviveItem)item;
        PlayerPartyStorage party = StorageProxy.getParty(player);
        Pokemon pokemon = party.find(this.pokemonUUID);
        if (pokemon != null && revive.useMedicine(new DelegateLink(pokemon), 0) && !player.func_184812_l_()) {
            itemStack.func_190918_g(1);
        }
    }
}

