/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.enums.EnumFeatureState;
import com.pixelmonmod.pixelmon.enums.items.EnumCharms;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class SetCharmPacket
extends AbstractPixelmonPacket {
    private EnumCharms charm;
    private EnumFeatureState state;

    public SetCharmPacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public SetCharmPacket(EnumCharms charm, EnumFeatureState state) {
        this();
        this.charm = charm;
        this.state = state;
    }

    @Override
    public void decode(PacketBuffer buffer) {
        short i = buffer.readShort();
        short j = buffer.readShort();
        this.charm = i >= 0 && i < EnumCharms.values().length ? EnumCharms.values()[i] : null;
        this.state = j >= 0 && j < EnumFeatureState.values().length ? EnumFeatureState.values()[j] : null;
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.writeShort(this.charm.ordinal());
        buffer.writeShort(this.state.ordinal());
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player;
        if (this.charm != null && this.state != null && (player = context.getSender()) != null) {
            PlayerPartyStorage storage = StorageProxy.getParty(player);
            switch (this.charm) {
                case Shiny: {
                    if (storage.getShinyCharm() == EnumFeatureState.Disabled) break;
                    storage.setShinyCharm(this.state);
                    break;
                }
                case Oval: {
                    if (storage.getOvalCharm() == EnumFeatureState.Disabled) break;
                    storage.setOvalCharm(this.state);
                    break;
                }
                case Exp: {
                    if (storage.getExpCharm() == EnumFeatureState.Disabled) break;
                    storage.setExpCharm(this.state);
                    break;
                }
                case Catching: {
                    if (storage.getCatchingCharm() == EnumFeatureState.Disabled) break;
                    storage.setCatchingCharm(this.state);
                    break;
                }
                case Mark: {
                    if (storage.getMarkCharm() == EnumFeatureState.Disabled) break;
                    storage.setMarkCharm(this.state);
                }
            }
        }
    }
}

