/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.npc.TeachMoveEvent;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.data.AbstractPixelmonPacket;
import com.pixelmonmod.pixelmon.comm.data.PacketDirection;
import com.pixelmonmod.pixelmon.comm.data.PacketInfo;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenReplaceMoveScreenPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

@PacketInfo(value={NetworkDirection.PLAY_TO_SERVER})
public class NPCTeachMovePacket
extends AbstractPixelmonPacket {
    private UUID pokemonUUID;
    private String attackId;
    private int npcId;

    public NPCTeachMovePacket() {
        super(PacketDirection.PLAY_SERVER, true);
    }

    public NPCTeachMovePacket(UUID pokemonUUID, String attackId, int npcId) {
        super(PacketDirection.PLAY_SERVER, true);
        this.pokemonUUID = pokemonUUID;
        this.attackId = attackId;
        this.npcId = npcId;
    }

    @Override
    public void decode(PacketBuffer buffer) {
        this.pokemonUUID = buffer.func_179253_g();
        this.attackId = buffer.func_218666_n();
        this.npcId = buffer.readInt();
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179252_a(this.pokemonUUID);
        buffer.func_180714_a(this.attackId);
        buffer.writeInt(this.npcId);
    }

    @Override
    protected void handlePacket(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        ImmutableAttack attack = AttackRegistry.getAttackBase(this.attackId).orElse(null);
        if (attack == null) {
            return;
        }
        Pokemon pokemon = StorageProxy.getParty(player).find(this.pokemonUUID);
        if (pokemon == null) {
            return;
        }
        List<ItemStack> costs = new ArrayList<ItemStack>();
        Optional<NPCEntity> npc = NPCEntity.locateNPCServer(player.field_70170_p, this.npcId, NPCEntity.class);
        if (!npc.isPresent() || npc.get().func_70068_e((Entity)player) > 4096.0) {
            return;
        }
        if (!(npc.get() instanceof NPCRelearner) && !(npc.get() instanceof NPCTutor)) {
            return;
        }
        if (npc.get() instanceof NPCRelearner) {
            List<ImmutableAttack> attackList = NPCRelearner.getRelearnableMoves(pokemon);
            if (!attackList.contains(attack)) {
                return;
            }
            NPCRelearner relearner = (NPCRelearner)npc.get();
            ItemStack cost = relearner.getCost();
            if (!cost.func_190926_b()) {
                costs.add(cost);
            }
        } else {
            NPCTutor tutor = (NPCTutor)npc.get();
            if (!this.canFindMove(tutor.moveList, attack) || !tutor.canLearn(player, pokemon, attack)) {
                return;
            }
            for (int i = 0; i < tutor.moveList.size(); ++i) {
                List<ItemStack> array;
                if (!tutor.moveList.get(i).attack().isAttack(attack) || (array = tutor.moveList.get(i).costs()).size() < 1) continue;
                costs = array;
            }
        }
        if (Pixelmon.EVENT_BUS.post((Event)new TeachMoveEvent.MoveLearnt.Pre((PlayerEntity)player, pokemon, npc.orElse(null), attack))) {
            return;
        }
        if (!costs.isEmpty() && !player.func_184812_l_()) {
            LearnMoveController.addLearnMove(player, pokemon.getUUID(), attack, LearnMoveController.itemCostCondition(costs));
        } else {
            LearnMoveController.addLearnMove(player, pokemon.getUUID(), attack);
        }
        if (pokemon.getMoveset().size() >= 4) {
            this.reply(context, new OpenReplaceMoveScreenPacket(pokemon.getUUID(), attack));
        } else {
            boolean messageSent = LearnMoveController.hasCondition(player, this.pokemonUUID, attack);
            if (LearnMoveController.canLearnMove(player, pokemon.getUUID(), attack)) {
                pokemon.getMoveset().add(new Attack(attack));
                ChatHandler.sendChat((Entity)player, "pixelmon.stats.learnedmove", pokemon.getDisplayName(), attack.getTranslatedName());
                Pixelmon.EVENT_BUS.post((Event)new TeachMoveEvent.MoveLearnt.Post((PlayerEntity)player, pokemon, npc.orElse(null), attack));
            } else if (!messageSent) {
                ChatHandler.sendFormattedChat((ICommandSource)player, TextFormatting.RED, "pixelmon.npc.cantpay", new Object[0]);
            }
        }
    }

    private boolean canFindMove(List<NPCTutor.LearnableMove> moveList, ImmutableAttack attack) {
        for (NPCTutor.LearnableMove learnableMove : moveList) {
            if (!learnableMove.attack().isAttack(attack)) continue;
            return true;
        }
        return false;
    }
}

