/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.QuaternionHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.blocks.machines.TimespaceAltarBlock;
import com.pixelmonmod.pixelmon.blocks.tileentity.TimespaceAltarTileEntity;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystems;
import com.pixelmonmod.pixelmon.client.particle.particles.SmallRising;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RenderTileEntityTimespaceAltar
extends TileEntityRenderer<TimespaceAltarTileEntity> {
    private static final GenericModelHolder<GenericSmdModel> lustrous_orb = new GenericModelHolder("blocks/shrines/timespace/lustrous_orb.pqc");
    private static final ResourceLocation lustrous_orb_texture = ResourceLocationHelper.of("pixelmon", "textures/block/shrines/timespace/lustrous_orb.png");
    private static final GenericModelHolder<GenericSmdModel> adamant_orb = new GenericModelHolder("blocks/shrines/timespace/adamant_orb.pqc");
    private static final ResourceLocation adamant_orb_texture = ResourceLocationHelper.of("pixelmon", "textures/block/shrines/timespace/adamant_orb.png");
    private static final GenericModelHolder<GenericSmdModel> griseous_orb = new GenericModelHolder("blocks/shrines/timespace/griseous_orb.pqc");
    private static final ResourceLocation griseous_orb_texture = ResourceLocationHelper.of("pixelmon", "textures/block/shrines/timespace/griseous_orb.png");
    private double theta = 0.0;
    private PixelmonEntity pokemonToRender;

    public RenderTileEntityTimespaceAltar(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        this.correctionAngles = 180;
    }

    @Override
    public void render(TimespaceAltarTileEntity shrineBlock, BlockState state, double x, double y, double z, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        double zOffset;
        double xOffset;
        if (!(state.func_177230_c() instanceof TimespaceAltarBlock)) {
            return;
        }
        matrix.func_227860_a_();
        Direction direction = (Direction)state.func_177229_b((Property)TimespaceAltarBlock.FACING);
        if (direction == Direction.SOUTH) {
            xOffset = 0.5;
            zOffset = -4.5;
        } else if (direction == Direction.NORTH) {
            xOffset = 0.5;
            zOffset = 5.5;
        } else if (direction == Direction.WEST) {
            xOffset = 5.5;
            zOffset = 0.5;
        } else {
            xOffset = -4.5;
            zOffset = 0.5;
        }
        BlockPos center = new BlockPos((double)shrineBlock.func_174877_v().func_177958_n() + xOffset, (double)shrineBlock.func_174877_v().func_177956_o(), (double)shrineBlock.func_174877_v().func_177952_p() + zOffset);
        if (shrineBlock.timeSpent > 0) {
            PixelmonEntity pokemon;
            float gb2 = shrineBlock.flutePlayed ? 1.0f : Math.min(0.98f, (float)shrineBlock.timeSpent / 200.0f) + 0.02f;
            matrix.func_227861_a_(0.0, (double)((1.0f - (float)shrineBlock.timeSpent / 200.0f) * 5.0f), 0.0);
            matrix.func_227861_a_(0.0, (double)((float)(-shrineBlock.timeSpent) / 200.0f * 5.0f), 0.0);
            if (shrineBlock.flutePlayed) {
                matrix.func_227861_a_(0.0, 3.5, -5.0);
                matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
                pokemon = this.getPokemonToRender(PixelmonSpecies.ARCEUS.getValueUnsafe());
                pokemon.setRenderColor(1.0f, gb2, gb2, 1.0f);
                PixelmonRendering.renderEntity(matrix, pokemon, false, partialTicks);
            } else {
                switch (shrineBlock.orbIn) {
                    case PALKIA: {
                        matrix.func_227861_a_(0.0, 3.5, -5.0);
                        matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
                        pokemon = this.getPokemonToRender(PixelmonSpecies.PALKIA.getValueUnsafe());
                        pokemon.setRenderColor(1.0f, gb2, gb2, 1.0f);
                        PixelmonRendering.renderEntity(matrix, pokemon, false, partialTicks);
                        break;
                    }
                    case DIALGA: {
                        matrix.func_227861_a_(0.0, 3.0, -5.0);
                        matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
                        pokemon = this.getPokemonToRender(PixelmonSpecies.DIALGA.getValueUnsafe());
                        pokemon.setRenderColor(1.0f, gb2, gb2, 1.0f);
                        PixelmonRendering.renderEntity(matrix, pokemon, false, partialTicks);
                        break;
                    }
                    case GIRATINA: {
                        matrix.func_227861_a_(0.0, 4.0, -5.0);
                        matrix.func_227863_a_(QuaternionHelper.fromEuler(180.0f, 1.0f, 0.0f, 0.0f));
                        pokemon = this.getPokemonToRender(PixelmonSpecies.GIRATINA.getValueUnsafe());
                        pokemon.setRenderColor(1.0f, gb2, gb2, 1.0f);
                        PixelmonRendering.renderEntity(matrix, pokemon, false, partialTicks);
                        break;
                    }
                }
            }
            int totalPoints = (int)((float)shrineBlock.timeSpent / 20.0f);
            for (int i = 0; i < totalPoints; ++i) {
                double pX = (double)shrineBlock.func_174877_v().func_177958_n() + xOffset + (double)RandomHelper.getRandomNumberBetween(-4.0f, 4.0f);
                double pZ = (double)shrineBlock.func_174877_v().func_177952_p() + zOffset + (double)RandomHelper.getRandomNumberBetween(-4.0f, 4.0f);
                if (!(center.func_218140_a(pX, (double)shrineBlock.func_174877_v().func_177956_o(), pZ, true) < 16.0)) continue;
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleArcanery(pX, shrineBlock.func_174877_v().func_177956_o(), pZ, 0.0, 1.0, 0.0, new SmallRising(1.0f, shrineBlock.flutePlayed ? 1.0f : 0.0f, shrineBlock.flutePlayed ? 1.0f : 0.0f, 0.5f)));
            }
            ParticleSystems.get(1).execute(Minecraft.func_71410_x(), (World)Minecraft.func_71410_x().field_71441_e, (double)shrineBlock.func_174877_v().func_177958_n() + xOffset, (double)shrineBlock.func_174877_v().func_177956_o() + 0.5, (double)shrineBlock.func_174877_v().func_177952_p() + zOffset, 0.0f, false, shrineBlock.flutePlayed ? 1.0 : 0.0);
        } else if (shrineBlock.chainIn) {
            int totalPoints = 16;
            for (int i = 1; i <= totalPoints; ++i) {
                double theta = Math.PI * 2 / (double)totalPoints;
                double angle = theta * (double)i + this.theta;
                this.theta += 7.5E-4;
                if (this.theta > Math.PI) {
                    this.theta -= Math.PI;
                }
                double radius = 4.0;
                double dx = radius * Math.sin(angle);
                double dz = radius * Math.cos(angle);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleArcanery((double)shrineBlock.func_174877_v().func_177958_n() + xOffset + dx, (double)shrineBlock.func_174877_v().func_177956_o() + 0.5, (double)shrineBlock.func_174877_v().func_177952_p() + zOffset + dz, 0.0, 0.0, 0.0, new SmallRising(1.0f, 0.0f, 0.0f, 0.5f)));
            }
        }
        matrix.func_227865_b_();
    }

    private PixelmonEntity getPokemonToRender(Species species) {
        if (this.pokemonToRender == null || !this.pokemonToRender.getSpecies().is(species)) {
            Pokemon pokemon = PokemonFactory.create(species);
            pokemon.setShiny(false);
            pokemon.setGrowth(EnumGrowth.Ordinary);
            this.pokemonToRender = new PixelmonEntity(this.field_228858_b_.field_147550_f, pokemon);
        }
        return this.pokemonToRender;
    }
}

