/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.entity.renderers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.PixelmonRendering;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.entities.custom.PixelmonBoatEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class PixelmonBoatRenderer
extends BoatRenderer {
    private Map<String, ResourceLocation> textureCache = Maps.newHashMap();
    private Map<UUID, PixelmonEntity> entities = Maps.newHashMap();

    public PixelmonBoatRenderer(EntityRendererManager p_i46190_1_) {
        super(p_i46190_1_);
    }

    public void func_225623_a_(BoatEntity entity, float p_225623_2_, float p_225623_3_, MatrixStack matrix, IRenderTypeBuffer buffer, int partialTick) {
        super.func_225623_a_(entity, p_225623_2_, p_225623_3_, matrix, buffer, partialTick);
        if (!(entity.func_184179_bs() instanceof PlayerEntity) || !Objects.equals(entity.func_184179_bs().func_110124_au(), Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
            this.entities.clear();
            return;
        }
        matrix.func_227860_a_();
        int counter = 0;
        for (Pokemon pokemon : ClientStorageManager.party.getAll()) {
            if (pokemon == null || !pokemon.getSpecies().is(PixelmonSpecies.MAGIKARP)) continue;
            matrix.func_227860_a_();
            PixelmonEntity pixelmonEntity = this.getEntity(pokemon, entity);
            pixelmonEntity.getAnimationVariables().tick();
            Vector3d lookAngle = entity.func_70040_Z();
            matrix.func_227861_a_(-lookAngle.field_72450_a * ((double)(2 * (counter + 1)) + Math.sin(counter)), -0.5, -lookAngle.field_72449_c * (double)(2 * (counter + 1)) + Math.sin(counter));
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - p_225623_2_));
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            PixelmonRendering.renderEntity(matrix, pixelmonEntity, false, partialTick);
            matrix.func_227865_b_();
            ++counter;
        }
        matrix.func_227865_b_();
    }

    private PixelmonEntity getEntity(Pokemon pokemon, BoatEntity entity) {
        return this.entities.computeIfAbsent(pokemon.getUUID(), ___ -> {
            PixelmonEntity pixelmonEntity = new PixelmonEntity(entity.field_70170_p, pokemon);
            pixelmonEntity.field_70177_z = entity.field_70177_z;
            pixelmonEntity.field_70759_as = entity.field_70177_z;
            pixelmonEntity.setDisableNametag(true);
            pixelmonEntity.setAnimation(AnimationType.SWIM);
            return pixelmonEntity;
        });
    }

    public ResourceLocation func_110775_a(BoatEntity p_110775_1_) {
        String name = ((PixelmonBoatEntity)p_110775_1_).getWoodType().func_227048_b_().toLowerCase(Locale.ROOT);
        return this.textureCache.computeIfAbsent(name, ___ -> ResourceLocationHelper.of("pixelmon", "textures/entity/boat/" + name.replace("pixelmon:", "") + ".png"));
    }
}

