/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.widgets.TextAlignment;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;

public class DescriptiveText {
    private String text;
    private String description;
    private int x;
    private int y;
    private TextAlignment align;
    private Rectangle boundingBox;

    public DescriptiveText(String text, String description, int x, int y, TextAlignment align) {
        this.text = text;
        this.description = description;
        this.x = x;
        this.y = y;
        this.align = align;
        int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
        int height = 10;
        int boxX = x;
        int boxY = y;
        switch (align) {
            case Left: {
                boxX = x;
                break;
            }
            case Center: {
                boxX = x - width / 2;
                break;
            }
            case Right: {
                boxX = x - width;
            }
        }
        this.boundingBox = new Rectangle(boxX, boxY, width, height);
    }

    public void draw(MatrixStack matrix) {
        switch (this.align) {
            case Left: {
                Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrix, this.text, (float)this.x, (float)this.y, 0);
                break;
            }
            case Center: {
                ScreenHelper.drawCenteredString(matrix, this.text, (float)this.x, (float)this.y, 0);
                break;
            }
            case Right: {
                ScreenHelper.drawStringRightAligned(matrix, this.text, this.x, this.y, 0, false);
            }
        }
    }

    public boolean isHovering(int cursorX, int cursorY) {
        return this.boundingBox.contains(cursorX, cursorY);
    }

    public String getDescription() {
        return this.description;
    }
}

