/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npcEditor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.api.pokemon.PokemonSpecification;
import com.pixelmonmod.api.pokemon.PokemonSpecificationProxy;
import com.pixelmonmod.api.pokemon.requirement.impl.ShinyRequirement;
import com.pixelmonmod.api.pokemon.requirement.impl.SpeciesRequirement;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TextureEditorNPC;
import com.pixelmonmod.pixelmon.client.gui.widgets.DropDownScreen;
import com.pixelmonmod.pixelmon.client.gui.widgets.IndexedButton;
import com.pixelmonmod.pixelmon.client.gui.widgets.TabCompleteTextField;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.DeleteTrainerPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.NPCServerPacket;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class TradeEditorScreen
extends DropDownScreen {
    public int top;
    public int left;
    TextFieldWidget offerName;
    TextFieldWidget exchangeName;
    TextFieldWidget descriptionTextBox;
    NPCTrader trader;
    PokemonSpecification offer;
    boolean offerChanged = false;
    PokemonSpecification exchange;
    boolean exchangeChanged = false;
    String description;
    private TextureEditorNPC textureEditor;

    public TradeEditorScreen(int traderId) {
        super(StringTextComponent.field_240750_d_);
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.xSize = 256;
        this.ySize = 226;
        Optional<NPCTrader> entityNPCOptional = NPCEntity.locateNPCClient((World)Minecraft.func_71410_x().field_71441_e, traderId, NPCTrader.class);
        if (!entityNPCOptional.isPresent()) {
            ScreenHelper.closeScreen();
            return;
        }
        this.trader = entityNPCOptional.get();
        this.offer = ClientProxy.currentTradePair.offer;
        this.exchange = ClientProxy.currentTradePair.exchange;
        this.description = ClientProxy.currentTradePair.description;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        if (this.trader == null) {
            ScreenHelper.closeScreen();
            return;
        }
        if (ClientProxy.currentTradePair == null) {
            ClientProxy.currentTradePair = new TradePair(PokemonSpecificationProxy.create("random"), PokemonSpecificationProxy.create("random"));
        }
        this.left = (this.field_230708_k_ - this.xSize) / 2;
        this.top = (this.field_230709_l_ - this.ySize) / 2;
        this.offerName = new TabCompleteTextField(6, this.field_230706_i_.field_71466_p, this.field_230708_k_ / 2 - 45, this.field_230709_l_ / 2 + 10, 90, 17).setCompletions(PixelmonSpecies.getFormattedEnglishNameSet());
        this.offerName.func_146203_f(150);
        this.offerName.func_146180_a(this.offer.getValue(SpeciesRequirement.class).orElse(PixelmonSpecies.MISSINGNO).getValueUnsafe().getName());
        this.func_230480_a_((Widget)this.offerName);
        this.exchangeName = new TabCompleteTextField(7, this.field_230706_i_.field_71466_p, this.field_230708_k_ / 2 + 100, this.field_230709_l_ / 2 + 10, 90, 17).setCompletions(PixelmonSpecies.getFormattedEnglishNameSet());
        this.exchangeName.func_146203_f(150);
        this.exchangeName.func_146180_a(this.exchange.getValue(SpeciesRequirement.class).orElse(PixelmonSpecies.MISSINGNO).getValueUnsafe().getName());
        this.func_230480_a_((Widget)this.exchangeName);
        this.descriptionTextBox = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.field_230708_k_ / 2 - 45, this.field_230709_l_ / 2 + 50, 235, 15, StringTextComponent.field_240750_d_);
        this.descriptionTextBox.func_146203_f(150);
        if (this.description != null) {
            this.descriptionTextBox.func_146180_a(this.description);
        }
        this.func_230480_a_((Widget)this.descriptionTextBox);
        this.func_230480_a_((Widget)new IndexedButton(0, this.field_230708_k_ / 2 + 155, this.field_230709_l_ / 2 + 90, 30, 20, (ITextComponent)new TranslationTextComponent("gui.guiItemDrops.ok"), this::actionPerformed));
        this.func_230480_a_((Widget)new IndexedButton(1, this.field_230708_k_ / 2 + 100, this.field_230709_l_ / 2 - 110, 80, 20, (ITextComponent)new TranslationTextComponent("gui.tradereditor.delete"), this::actionPerformed));
        this.func_230480_a_((Widget)new IndexedButton(2, this.field_230708_k_ / 2 - 40, this.field_230709_l_ / 2 - 110, 80, 20, (ITextComponent)new TranslationTextComponent("gui.tradereditor.random"), this::actionPerformed));
        this.func_230480_a_((Widget)new IndexedButton(3, this.field_230708_k_ / 2 + 58, this.field_230709_l_ / 2 + 9, 30, 20, (ITextComponent)new StringTextComponent("<->"), this::actionPerformed));
        this.textureEditor = new TextureEditorNPC(this, this.trader, this.field_230708_k_ / 2 - 190, this.field_230709_l_ / 2 + 50, 130, -23);
        this.field_230705_e_.add(this.textureEditor.customTextureBox);
    }

    @Override
    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void drawBackgroundUnderMenus(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        ScreenHelper.drawImageQuad(Resources.cwPanel, matrix, (float)this.field_230708_k_ / 2.0f - 200.0f, (float)this.field_230709_l_ / 2.0f - 120.0f, 400.0f, 240.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.75f, 0.0f);
        RenderHelper.func_74518_a();
        ScreenHelper.drawEntity(matrix, (LivingEntity)this.trader, this.field_230708_k_ / 2 - 125, this.field_230709_l_ / 2 + 40, 50.0f, 0.0f, 0.0f);
        if (ClientProxy.currentTradePair.offer.getValue(ShinyRequirement.class).orElse(false).booleanValue()) {
            this.offerName.func_146193_g(0xFFFF33);
        } else {
            this.offerName.func_146193_g(0xFFFFFF);
        }
        this.offerName.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        if (ClientProxy.currentTradePair.offer.getValue(ShinyRequirement.class).orElse(false).booleanValue()) {
            this.exchangeName.func_146193_g(0xFFFF33);
        } else {
            this.exchangeName.func_146193_g(0xFFFFFF);
        }
        this.exchangeName.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        this.descriptionTextBox.func_230431_b_(matrix, mouseX, mouseY, partialTicks);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.tradereditor.offer", (Object[])new Object[0]), (float)(this.left + 85), (float)(this.top + 110), 0);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.tradereditor.exchange", (Object[])new Object[0]), (float)(this.left + 225), (float)(this.top + 110), 0);
        this.field_230706_i_.field_71466_p.func_238421_b_(matrix, I18n.func_135052_a((String)"gui.tradereditor.description", (Object[])new Object[0]), (float)(this.left + 85), (float)(this.top + 150), 0);
        this.textureEditor.drawCustomTextBox(matrix, mouseX, mouseY, partialTicks);
    }

    public boolean func_231042_a_(char key, int keyCode) {
        if (keyCode == 256 || keyCode == 257) {
            this.saveFields();
        }
        if (this.func_241217_q_() == this.offerName) {
            this.offerChanged = true;
        }
        if (this.func_241217_q_() == this.exchangeName) {
            this.exchangeChanged = true;
        }
        return super.func_231042_a_(key, keyCode);
    }

    @Override
    public boolean mouseClickedUnderMenus(double x, double y, int mouseButton) {
        if (ClientStorageManager.party.inTemporaryMode()) {
            return true;
        }
        this.offerName.func_231044_a_(x, y, mouseButton);
        this.exchangeName.func_231044_a_(x, y, mouseButton);
        this.descriptionTextBox.func_231044_a_(x, y, mouseButton);
        this.textureEditor.mouseClicked(x, y, mouseButton);
        return super.mouseClickedUnderMenus(x, y, mouseButton);
    }

    protected void actionPerformed(Button button) {
        if (button.field_230693_o_ && button instanceof IndexedButton) {
            int id = ((IndexedButton)button).id;
            if (id == 0) {
                this.saveFields();
            } else if (id == 1) {
                ScreenHelper.closeScreen();
                Minecraft.func_71410_x().func_175607_a((Entity)Minecraft.func_71410_x().field_71439_g);
                NetworkHelper.sendToServer(new DeleteTrainerPacket(this.trader.getNPCID()));
            } else if (id == 2) {
                List<Species> list = PixelmonSpecies.getAll();
                String poke1 = RandomHelper.getRandomElementFromCollection(list).getName();
                String poke2 = RandomHelper.getRandomElementFromCollection(list).getName();
                if (poke2.equalsIgnoreCase(poke1)) {
                    poke2 = RandomHelper.getRandomElementFromCollection(list).getName();
                }
                this.offerName.func_146180_a(poke1);
                this.exchangeName.func_146180_a(poke2);
                this.exchangeChanged = true;
                this.offerChanged = true;
            } else if (id == 3) {
                String text = this.offerName.func_146179_b();
                this.offerName.func_146180_a(this.exchangeName.func_146179_b());
                this.exchangeName.func_146180_a(text);
                this.exchangeChanged = true;
                this.offerChanged = true;
            }
        }
    }

    @Override
    public boolean func_231177_au__() {
        return false;
    }

    private void saveFields() {
        String offerText = this.offerName.func_146179_b();
        String exchangeText = this.exchangeName.func_146179_b();
        this.description = this.descriptionTextBox.func_146179_b();
        PokemonSpecification offer = PokemonSpecificationProxy.create(offerText.split(" "));
        PokemonSpecification exchange = PokemonSpecificationProxy.create(exchangeText.split(" "));
        if (exchange.getValue(SpeciesRequirement.class).isPresent() && offer.getValue(SpeciesRequirement.class).isPresent()) {
            this.setNewTradePokemon(this.offerChanged ? offer : this.offer, this.exchangeChanged ? exchange : this.exchange);
            this.exchangeChanged = false;
            this.offerChanged = false;
            ScreenHelper.closeScreen();
            Minecraft.func_71410_x().func_175607_a((Entity)Minecraft.func_71410_x().field_71439_g);
        }
        this.textureEditor.saveCustomTexture();
    }

    private void setNewTradePokemon(PokemonSpecification offer, PokemonSpecification exchange) {
        ClientProxy.currentTradePair = new TradePair(offer, exchange, this.description);
        NetworkHelper.sendToServer(new NPCServerPacket(this.trader.getNPCID(), offer, exchange, this.description));
    }
}

