/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.blocks;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.blocks.TumblestoneBlockEvent;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.init.registry.PixelmonTags;
import com.pixelmonmod.pixelmon.items.HammerItem;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;

public class TumblestoneBlock
extends Block
implements IWaterLoggable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208169_V;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final IntegerProperty DESTROYED = IntegerProperty.func_177719_a((String)"destroyed", (int)0, (int)3);

    public TumblestoneBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185853_f).func_200944_c().func_235861_h_().harvestTool(PixelmonTags.HAMMER).func_200948_a(5.0f, 1000.0f).func_208770_d().func_226896_b_().func_235838_a_(value -> {
            if (!value.func_235901_b_((Property)AGE)) {
                return 0;
            }
            if ((Integer)value.func_177229_b((Property)DESTROYED) > 0) {
                return 3;
            }
            return 3 * (Integer)value.func_177229_b((Property)AGE);
        }).func_235856_e_((p_test_1_, p_test_2_, p_test_3_) -> true));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DESTROYED, (Comparable)Integer.valueOf(0)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addDestroyEffects(BlockState state, World world, BlockPos pos, ParticleManager manager) {
        return super.addDestroyEffects(state, world, pos, manager);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)PixelmonItems.tumblestone);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        super.func_206840_a(p_206840_1_);
        p_206840_1_.func_206894_a(new Property[]{AGE, WATERLOGGED, DESTROYED});
    }

    public FluidState func_204507_t(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(p_204507_1_);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_180495_p(context.func_195995_a()).func_204520_s().func_206889_d()));
    }

    public void func_225542_b_(BlockState state, ServerWorld level, BlockPos pos, Random rand) {
        int destroyedState = (Integer)state.func_177229_b((Property)DESTROYED);
        if (destroyedState == 3) {
            TumblestoneBlockEvent.PreCooldownEnd cooldownPreEvent = new TumblestoneBlockEvent.PreCooldownEnd((World)level, state, pos, PixelmonConfigProxy.getDimensions().getTumblestoneRestoreChance());
            if (Pixelmon.EVENT_BUS.post((Event)cooldownPreEvent)) {
                return;
            }
            boolean success = false;
            if (RandomHelper.getRandomChance(cooldownPreEvent.getChance())) {
                state = this.func_176223_P();
                level.func_180501_a(pos, state, 2);
                success = true;
            }
            Pixelmon.EVENT_BUS.post((Event)new TumblestoneBlockEvent.PostCooldownEnd((World)level, state, pos, success, cooldownPreEvent.getChance()));
            return;
        }
        int i = (Integer)state.func_177229_b((Property)AGE);
        float chance = PixelmonConfigProxy.getDimensions().getTumblestoneGrowthChance();
        TumblestoneBlockEvent.PreGrow growthEvent = new TumblestoneBlockEvent.PreGrow((World)level, state, pos, chance);
        if (Pixelmon.EVENT_BUS.post((Event)growthEvent)) {
            return;
        }
        if (i < 5 && RandomHelper.getRandomChance(growthEvent.getChance())) {
            state = (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            level.func_180501_a(pos, state, 2);
            Pixelmon.EVENT_BUS.post((Event)new TumblestoneBlockEvent.PostGrow((World)level, state, pos, growthEvent.getChance()));
        }
        super.func_225542_b_(state, level, pos, rand);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        if (player.func_184812_l_()) {
            return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        if (world.field_72995_K) {
            return false;
        }
        ItemStack itemInHand = player.func_184586_b(Hand.MAIN_HAND);
        if (!(itemInHand.func_77973_b() instanceof HammerItem)) {
            return false;
        }
        int age = (Integer)state.func_177229_b((Property)AGE);
        if (age < 5) {
            return false;
        }
        int destroyed = (Integer)state.func_177229_b((Property)DESTROYED);
        if (destroyed == 3) {
            return false;
        }
        TumblestoneBlockEvent.PreBlockDestroy destroyEvent = new TumblestoneBlockEvent.PreBlockDestroy(world, state, pos, player, itemInHand);
        if (Pixelmon.EVENT_BUS.post((Event)destroyEvent)) {
            return false;
        }
        ++destroyed;
        if (Objects.equals(itemInHand.func_77973_b(), PixelmonItems.beef_hammer)) {
            destroyed = 3;
        }
        if (destroyed > 3) {
            destroyed = 3;
        }
        state = (BlockState)state.func_206870_a((Property)DESTROYED, (Comparable)Integer.valueOf(destroyed));
        world.func_180501_a(pos, state, 2);
        world.func_184138_a(pos, state, state, 11);
        world.func_225524_e_().func_215568_a(pos);
        if (destroyed == 3) {
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)world).func_216023_a(world.field_73012_v).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)itemInHand);
            List drops = this.func_220076_a(state, lootcontext$builder);
            TumblestoneBlockEvent.PreBlockBroke breakEvent = new TumblestoneBlockEvent.PreBlockBroke(world, state, pos, player, itemInHand, drops);
            if (Pixelmon.EVENT_BUS.post((Event)breakEvent)) {
                return false;
            }
            world.func_180501_a(pos, state, 2);
            for (ItemStack drop : breakEvent.getDrops()) {
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), drop);
                breakEvent.getWorld().func_217376_c((Entity)itemEntity);
            }
            Pixelmon.EVENT_BUS.post((Event)new TumblestoneBlockEvent.PostBlockBroke(world, state, pos, player, itemInHand, breakEvent.getDrops()));
        }
        Pixelmon.EVENT_BUS.post((Event)new TumblestoneBlockEvent.PostBlockDestroy(world, state, pos, player, itemInHand));
        return false;
    }

    public float func_180647_a(BlockState state, PlayerEntity p_180647_2_, IBlockReader p_180647_3_, BlockPos p_180647_4_) {
        int age = (Integer)state.func_177229_b((Property)AGE);
        if (age < 5 || (Integer)state.func_177229_b((Property)DESTROYED) >= 3) {
            return 0.0f;
        }
        ItemStack itemInHand = p_180647_2_.func_184586_b(Hand.MAIN_HAND);
        if (Objects.equals(itemInHand.func_77973_b(), PixelmonItems.beef_hammer)) {
            return 0.9f;
        }
        return super.func_180647_a(state, p_180647_2_, p_180647_3_, p_180647_4_);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        if ((Integer)state.func_177229_b((Property)AGE) > 3 && (Integer)state.func_177229_b((Property)DESTROYED) < 3) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)2.0, (double)1.0);
        }
        return VoxelShapes.func_197868_b();
    }
}

