/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Protect;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.List;

public class MatBlock
extends StatusBase {
    public MatBlock() {
        super(StatusType.MatBlock);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.isFirstTurn() && !user.bc.isLastMover() && user.addTeamStatus(new MatBlock(), user)) {
            user.bc.sendToAll("pixelmon.status.matblock", user.getNickname());
        } else {
            user.bc.sendToAll("pixelmon.effect.effectfailed", user.getNickname());
            user.attack.moveResult.result = AttackResult.failed;
        }
    }

    @Override
    public boolean isTeamStatus() {
        return true;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        pw.removeTeamStatus(this);
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        return user.attack.getAttackCategory() != AttackCategory.STATUS;
    }

    @Override
    public void stopsIncomingAttackMessage(PixelmonWrapper pokemon, PixelmonWrapper user) {
        user.bc.sendToAll("pixelmon.status.matblocked", pokemon.attack.getMove().getTranslatedName());
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, List<MoveChoice> userChoices, List<MoveChoice> bestUserChoices, List<MoveChoice> opponentChoices, List<MoveChoice> bestOpponentChoices) {
        for (List<MoveChoice> choices : MoveChoice.splitChoices(pw.getOpponentPokemon(), bestOpponentChoices)) {
            if (!MoveChoice.canOutspeed(choices, pw, bestUserChoices)) continue;
            return;
        }
        Protect protect = new Protect();
        protect.weightEffect(pw, userChoice, userChoices, bestUserChoices, opponentChoices, bestOpponentChoices);
        if (pw.bc.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getNumPokemon() > 1) {
            userChoice.raiseWeight(20 * pw.bc.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE).getNumPokemon());
        }
    }
}

