/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.MagicBounce;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;

public class MagicCoat
extends StatusBase {
    public MagicCoat() {
        super(StatusType.MagicCoat);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        user.bc.sendToAll("pixelmon.status.applymagiccoat", user.getNickname());
        user.addStatus(new MagicCoat(), user);
    }

    @Override
    public boolean stopsIncomingAttack(PixelmonWrapper pokemon, PixelmonWrapper user) {
        Attack a = user.attack;
        return MagicCoat.reflectMove(a, pokemon, user, "pixelmon.status.magiccoat");
    }

    public static boolean reflectMove(Attack a, PixelmonWrapper pokemon, PixelmonWrapper user, String message) {
        if (!(a.getAttackCategory() != AttackCategory.STATUS || a.isAttack(AttackRegistry.BESTOW, AttackRegistry.CURSE, AttackRegistry.GUARD_SWAP, AttackRegistry.HEART_SWAP, AttackRegistry.HELPING_HAND, AttackRegistry.LOCK_ON, AttackRegistry.MEMENTO, AttackRegistry.MIMIC, AttackRegistry.POWER_SWAP, AttackRegistry.PSYCH_UP, AttackRegistry.PSYCHO_SHIFT, AttackRegistry.ROLE_PLAY, AttackRegistry.SKILL_SWAP, AttackRegistry.SNATCH, AttackRegistry.SWITCHEROO, AttackRegistry.TRANSFORM, AttackRegistry.TRICK, AttackRegistry.EXTREME_EVOBOOST, AttackRegistry.SKETCH) || a.getMove().getTargetingInfo().hitsAll && a.getMove().getTargetingInfo().hitsSelf)) {
            user.bc.sendToAll(message, pokemon.getNickname());
            pokemon.targetIndex = 0;
            boolean allowed = false;
            Ability ability = user.getBattleAbility(pokemon);
            if (!(ability instanceof MagicBounce)) {
                allowed = ability.allowsIncomingAttack(user, pokemon, a);
            }
            if (allowed) {
                allowed = user.getUsableHeldItem().allowsIncomingAttack(user, pokemon, a);
            }
            if (allowed) {
                for (PixelmonWrapper ally : user.bc.getTeamPokemon(user)) {
                    if (ally.getBattleAbility().allowsIncomingAttackTeammate(ally, user, pokemon, a)) continue;
                    allowed = false;
                    break;
                }
            }
            if (!allowed) {
                return true;
            }
            if (!pokemon.getBattleAbility().allowsOutgoingAttack(pokemon, user, a)) {
                return true;
            }
            if (a.hasNoEffect(pokemon, user)) {
                user.bc.sendToAll("pixelmon.battletext.noeffect", user.getNickname());
                return true;
            }
            Attack oldAttack = user.attack;
            user.attack = a;
            a.applyAttackEffect(pokemon, user);
            user.attack = oldAttack;
            return true;
        }
        return false;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        pw.removeStatus(this);
    }
}

