/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.PropellerTail;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.Stalwart;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SwapPositionPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AllySwitch
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        if (user.bc.simulateMode) {
            return AttackResult.failed;
        }
        ArrayList<PixelmonWrapper> team = user.bc.getTeamPokemon(user.getParticipant());
        if (team.size() > 1 && user.bc.getTeam(user.getParticipant()).size() == 1) {
            PixelmonWrapper switchPokemon = null;
            if (user.bc.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.DOUBLE) {
                for (PixelmonWrapper pw : team) {
                    if (pw == user) continue;
                    switchPokemon = pw;
                }
            } else if (user.bc.rules.getOrDefault(BattleRuleRegistry.BATTLE_TYPE) == BattleType.TRIPLE) {
                if (user.battlePosition == 1) {
                    user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                    return AttackResult.failed;
                }
                for (PixelmonWrapper pw : team) {
                    if (pw.battlePosition == 1 || pw == user) continue;
                    switchPokemon = pw;
                }
            }
            if (switchPokemon == null || switchPokemon.isFainted()) {
                user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                return AttackResult.failed;
            }
            user.bc.sendToAll("pixelmon.effect.allyswitch", user.getNickname(), switchPokemon.getNickname());
            List<StatusBase> userStatuses = user.getStatuses();
            List<StatusBase> allyStatuses = switchPokemon.getStatuses();
            List<StatusBase> userPositionStatuses = this.removePositionStatuses(userStatuses);
            List<StatusBase> allyPositionStatuses = this.removePositionStatuses(allyStatuses);
            allyStatuses.addAll(userPositionStatuses.stream().collect(Collectors.toList()));
            userStatuses.addAll(allyPositionStatuses.stream().collect(Collectors.toList()));
            int userPosition = user.battlePosition;
            user.battlePosition = switchPokemon.battlePosition;
            switchPokemon.battlePosition = userPosition;
            if (!user.hasStatus(StatusType.FollowMe) && !switchPokemon.hasStatus(StatusType.FollowMe)) {
                for (int i = user.bc.turn + 1; i < user.bc.turnList.size(); ++i) {
                    PixelmonWrapper current = user.bc.turnList.get(i);
                    if (current == user || current == switchPokemon || current.attack == null || current.targets == null || current.getBattleAbility().isAbility((Class<? extends AbstractAbility>)PropellerTail.class) || current.getBattleAbility().isAbility((Class<? extends AbstractAbility>)Stalwart.class)) continue;
                    for (int j = 0; j < current.targets.size(); ++j) {
                        if (current.targets.get(j) == user) {
                            current.targets.set(j, switchPokemon);
                            continue;
                        }
                        if (current.targets.get(j) != switchPokemon) continue;
                        current.targets.set(j, user);
                    }
                }
            }
            for (BattleParticipant participant : user.bc.participants) {
                if (participant.getType() != ParticipantType.Player) continue;
                NetworkHelper.sendPacket(new SwapPositionPacket(user, switchPokemon), ((PlayerParticipant)participant).player);
            }
            for (Spectator spectator : user.bc.spectators) {
                spectator.sendMessage(new SwapPositionPacket(user, switchPokemon));
            }
            return AttackResult.succeeded;
        }
        user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        return AttackResult.failed;
    }

    private List<StatusBase> removePositionStatuses(List<StatusBase> statuses) {
        ArrayList<StatusBase> positionStatuses = new ArrayList<StatusBase>(statuses.size());
        for (int i = 0; i < statuses.size(); ++i) {
            StatusBase status = statuses.get(i);
            if (!status.isTeamStatus() || status.isWholeTeamStatus()) continue;
            statuses.remove(status);
            positionStatuses.add(status);
        }
        return positionStatuses;
    }
}

