/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks;

import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.EffectBase;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.heldItems.EnumHeldItems;

public class MaxMoveConverter {
    public static Attack getMaxMoveFromAttack(Attack a, PixelmonWrapper pw) {
        Attack newAttack;
        ImmutableAttack base = a.getActualMove();
        if (base.getAttackCategory() == AttackCategory.STATUS) {
            newAttack = new Attack(AttackRegistry.MAX_GUARD);
            if (pw != null && pw.getUsableHeldItem().getHeldItemType() == EnumHeldItems.assaultVest) {
                newAttack.setDisabled(true, pw);
            } else {
                newAttack.setDisabled(false, pw);
            }
            newAttack.overrideType(Element.NORMAL);
        } else {
            if (a.isAttack(AttackRegistry.WEATHER_BALL, AttackRegistry.JUDGMENT, AttackRegistry.HIDDEN_POWER, AttackRegistry.MULTI_ATTACK) && pw != null) {
                for (EffectBase effect : base.effects) {
                    effect.applyEffectStart(pw, pw.targets.size() > 0 ? pw.targets.get(0) : null);
                }
            }
            newAttack = new Attack(MaxMoveConverter.getMaxMoveForType(a.getType()));
            newAttack.overrideAttackCategory(a.getAttackCategory());
            newAttack.overridePower = MaxMoveConverter.getMaxMovePowerForMove(a);
            newAttack.overridePPMax(10);
            newAttack.setDisabled(false, pw);
        }
        newAttack.isMax = true;
        newAttack.originalMove = a;
        return newAttack;
    }

    public static Attack getGMaxMoveFromAttack(Attack a, PixelmonWrapper pw, Species species, Stats form) {
        ImmutableAttack gmaxMove;
        ImmutableAttack base = a.getActualMove();
        if (base.getAttackCategory() != AttackCategory.STATUS && (gmaxMove = MaxMoveConverter.getGMaxMoveForType(a.getType(), form)) != null) {
            Attack newAttack = gmaxMove.ofMutable();
            newAttack.overrideAttackCategory(a.getAttackCategory());
            newAttack.overridePower = species.is(PixelmonSpecies.RILLABOOM) || species.is(PixelmonSpecies.CINDERACE) || species.is(PixelmonSpecies.INTELEON) ? 160 : MaxMoveConverter.getMaxMovePowerForMove(a);
            newAttack.overridePPMax(10);
            newAttack.setDisabled(false, pw);
            newAttack.isMax = true;
            newAttack.originalMove = a;
            return newAttack;
        }
        return MaxMoveConverter.getMaxMoveFromAttack(a, pw);
    }

    private static String getMaxMoveForType(Element type) {
        switch (type) {
            case GROUND: {
                return "Max Quake";
            }
            case WATER: {
                return "Max Geyser";
            }
            case ICE: {
                return "Max Hailstorm";
            }
            case BUG: {
                return "Max Flutterby";
            }
            case DARK: {
                return "Max Darkness";
            }
            case FIRE: {
                return "Max Flare";
            }
            case ROCK: {
                return "Max Rockfall";
            }
            case FAIRY: {
                return "Max Starfall";
            }
            case GHOST: {
                return "Max Phantasm";
            }
            case GRASS: {
                return "Max Overgrowth";
            }
            case STEEL: {
                return "Max Steelspike";
            }
            case DRAGON: {
                return "Max Wyrmwind";
            }
            case FLYING: {
                return "Max Airstream";
            }
            case NORMAL: {
                return "Max Strike";
            }
            case POISON: {
                return "Max Ooze";
            }
            case ELECTRIC: {
                return "Max Lightning";
            }
            case PSYCHIC: {
                return "Max Mindstorm";
            }
            case FIGHTING: {
                return "Max Knuckle";
            }
        }
        return "Max Strike";
    }

    private static ImmutableAttack getGMaxMoveForType(Element type, Stats form) {
        return form.getGigantamax().getMoveIfTypeMatches(type);
    }

    private static int getMaxMovePowerForMove(Attack a) {
        if (a.getType() == Element.FIGHTING || a.getType() == Element.POISON) {
            if (a.movePower >= 150) {
                return 100;
            }
            if (a.movePower >= 110) {
                return 95;
            }
            if (a.movePower >= 75) {
                return 90;
            }
            if (a.movePower >= 65) {
                return 85;
            }
            if (a.movePower >= 55) {
                return 80;
            }
            if (a.movePower >= 45) {
                return 75;
            }
            return 70;
        }
        if (a.isAttack(AttackRegistry.DUAL_WINGBEAT)) {
            return 130;
        }
        if (a.movePower >= 150) {
            return 150;
        }
        if (a.movePower >= 110) {
            return 140;
        }
        if (a.movePower >= 75) {
            return 130;
        }
        if (a.movePower >= 65) {
            return 120;
        }
        if (a.movePower >= 55) {
            return 110;
        }
        if (a.movePower >= 45) {
            return 100;
        }
        return 90;
    }
}

