/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.api.rules.clauses;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.util.IEncodeable;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TranslationTextComponent;

public class BattleClause
implements Comparable<BattleClause>,
IEncodeable {
    private String id;
    private String description = "";

    public BattleClause(String id) {
        this.id = id;
    }

    public BattleClause setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getID() {
        return this.id;
    }

    public String getDescription() {
        if (!this.description.isEmpty()) {
            return this.description;
        }
        return new TranslationTextComponent("gui.battlerules.description." + this.id).getString();
    }

    public String getLocalizedName() {
        return BattleClause.getLocalizedName(this.id);
    }

    public static String getLocalizedName(String clauseID) {
        String langKey = "gui.battlerules." + clauseID;
        return new TranslationTextComponent(langKey).getString();
    }

    public boolean validateSingle(Pokemon pokemon) {
        return true;
    }

    public boolean validateTeam(List<Pokemon> team) {
        for (Pokemon pokemon : team) {
            if (this.validateSingle(pokemon)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void encodeInto(PacketBuffer buffer) {
        buffer.func_180714_a(this.id);
        buffer.func_180714_a(this.description);
    }

    @Override
    public void decodeInto(PacketBuffer buffer) {
        this.id = buffer.func_218666_n();
        this.description = buffer.func_218666_n();
    }

    @Override
    public int compareTo(BattleClause o) {
        return this.id.compareTo(o.getID());
    }

    public boolean equals(Object other) {
        if (other instanceof BattleClause) {
            return ((BattleClause)other).getID().equals(this.id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return this.getLocalizedName();
    }
}

