/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.events.battles.BattleStartedEvent;
import com.pixelmonmod.pixelmon.api.events.npc.NPCEvent;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.eventbus.api.Event;

public class BattleRegistry {
    private static final AtomicInteger BATTLE_INDEX = new AtomicInteger(0);
    private static final Map<Integer, BattleController> BATTLES_BY_ID = Maps.newConcurrentMap();
    private static final Map<UUID, Integer> PLAYER_TO_BATTLE = Maps.newConcurrentMap();

    private BattleRegistry() {
        throw new UnsupportedOperationException("Static registry class for battles");
    }

    @Nullable
    public static BattleController startBattle(BattleParticipant[] team1, BattleParticipant[] team2, BattleRules rules) {
        BattleController battle = new BattleController(team1, team2, rules);
        if (!BattleRegistry.performPreBattleChecksAndEvents(battle, team1, team2)) {
            return null;
        }
        BattleRegistry.registerBattle(battle);
        Pixelmon.EVENT_BUS.post((Event)new BattleStartedEvent.Post(battle, team1, team2));
        return battle;
    }

    private static boolean performPreBattleChecksAndEvents(BattleController controller, BattleParticipant[] teamOne, BattleParticipant[] teamTwo) {
        if (!BattleRegistry.canParticipantsBattle(controller)) {
            return false;
        }
        if (BattleRegistry.attemptNpcBattleStartEvent(controller)) {
            return false;
        }
        return !Pixelmon.EVENT_BUS.post((Event)new BattleStartedEvent.Pre(controller, teamOne, teamTwo));
    }

    private static boolean canParticipantsBattle(BattleController controller) {
        for (BattleParticipant participant : controller.participants) {
            if (!BattleRegistry.isAlreadyInBattle(participant) && !BattleRegistry.hasEvolvingPokemon(participant)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAlreadyInBattle(BattleParticipant participant) {
        return participant instanceof PlayerParticipant && BattleRegistry.getBattle((PlayerEntity)((PlayerParticipant)participant).player) != null;
    }

    private static boolean hasEvolvingPokemon(BattleParticipant participant) {
        PartyStorage party = participant.getStorage();
        if (party == null) {
            return false;
        }
        return party.findOne(pokemon -> pokemon.getPixelmonEntity().isPresent() && pokemon.getPixelmonEntity().get().isEvolving()) != null;
    }

    private static boolean attemptNpcBattleStartEvent(BattleController controller) {
        BattleParticipant secondParticipant;
        if (controller.participants.size() != 2) {
            return false;
        }
        BattleParticipant firstParticipant = controller.participants.get(0);
        if (!BattleRegistry.arePlayerAndNpc(firstParticipant, secondParticipant = controller.participants.get(1)) && !BattleRegistry.arePlayerAndNpc(secondParticipant, firstParticipant)) {
            return false;
        }
        return Pixelmon.EVENT_BUS.post((Event)new NPCEvent.StartBattle(controller.participants));
    }

    private static boolean arePlayerAndNpc(BattleParticipant playerCheckedParticipant, BattleParticipant npcCheckedParticipant) {
        return playerCheckedParticipant instanceof PlayerParticipant && npcCheckedParticipant instanceof TrainerParticipant;
    }

    public static BattleController startBattle(BattleParticipant[] team1, BattleParticipant[] team2, BattleType type) {
        return BattleRegistry.startBattle(team1, team2, new BattleRules(type));
    }

    public static BattleController startBattle(BattleParticipant team1, BattleParticipant team2) {
        return BattleRegistry.startBattle(new BattleParticipant[]{team1}, new BattleParticipant[]{team2}, new BattleRules(BattleType.SINGLE));
    }

    public static void registerBattle(BattleController bc) {
        bc.battleIndex = BATTLE_INDEX.getAndIncrement();
        BATTLES_BY_ID.put(bc.battleIndex, bc);
        for (PlayerParticipant p : bc.getPlayers()) {
            PLAYER_TO_BATTLE.put(p.player.func_110124_au(), bc.battleIndex);
        }
    }

    public static BattleController getBattle(Integer index) {
        return index == null ? null : BATTLES_BY_ID.get(index);
    }

    public static BattleController getBattle(PlayerEntity player) {
        return player == null ? null : BattleRegistry.getBattle(PLAYER_TO_BATTLE.get(player.func_110124_au()));
    }

    public static BattleController getBattleExcludeSpectate(PlayerEntity player) {
        BattleController bc = BattleRegistry.getBattle(player);
        if (bc == null) {
            return null;
        }
        return bc.hasSpectator(player) ? null : bc;
    }

    public static BattleController getSpectatedBattle(PlayerEntity player) {
        return BATTLES_BY_ID.get(PLAYER_TO_BATTLE.get(player.func_110124_au()));
    }

    public static void registerSpectator(Spectator spectator, BattleController bc) {
        PLAYER_TO_BATTLE.put(spectator.getEntity().func_110124_au(), bc.battleIndex);
    }

    public static void unregisterSpectator(Spectator spectator) {
        PLAYER_TO_BATTLE.remove(spectator.getEntity().func_110124_au());
    }

    public static boolean removeSpectator(ServerPlayerEntity player) {
        BattleController battle = BattleRegistry.getBattle((PlayerEntity)player);
        if (battle != null) {
            return battle.removeSpectator(player);
        }
        return false;
    }

    public static void deRegisterBattle(BattleController bc) {
        if (bc != null) {
            BATTLES_BY_ID.remove(bc.battleIndex);
            for (PlayerParticipant p : bc.getPlayers()) {
                PLAYER_TO_BATTLE.remove(p.player.func_110124_au());
            }
            for (Spectator s : bc.spectators) {
                PLAYER_TO_BATTLE.remove(s.getEntity().func_110124_au());
            }
        }
    }

    public static void updateBattles() {
        for (BattleController base : Lists.newArrayList(BATTLES_BY_ID.values())) {
            base.update();
        }
    }
}

