/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.world;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockCollection {
    public final Entity cause;
    public final World world;
    public final int minX;
    public final int maxX;
    public final int minY;
    public final int maxY;
    public final int minZ;
    public final int maxZ;
    private BlockState[][][] blockData;
    private int[][] heightMap;
    private byte[][][] lightData;
    private Biome[][] biomeData;
    private Set<Block> uniqueBlocks = Sets.newHashSet();

    public BlockCollection(Entity cause, World world, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        this.cause = cause;
        this.world = world;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = MathHelper.func_76125_a((int)minY, (int)0, (int)255);
        this.maxY = MathHelper.func_76125_a((int)maxY, (int)0, (int)255);
        this.minZ = minZ;
        this.maxZ = maxZ;
        this.blockData = new BlockState[this.maxX - this.minX + 1][this.maxY - this.minY + 1][this.maxZ - this.minZ + 1];
        this.lightData = new byte[this.maxX - this.minX + 1][this.maxY - this.minY + 1][this.maxZ - this.minZ + 1];
        this.heightMap = new int[this.maxX - this.minX + 1][this.maxZ - this.minZ + 1];
        this.biomeData = new Biome[this.maxX - this.minX + 1][this.maxZ - this.minZ + 1];
        BlockPos.Mutable pos = new BlockPos.Mutable(this.minX, this.minY, this.minZ);
        BlockPos.Mutable lightPos = new BlockPos.Mutable(this.minX, this.minY, this.minZ);
        Chunk chunk = null;
        for (int x = 0; x < this.maxX - this.minX + 1; ++x) {
            for (int z = 0; z < this.maxZ - this.minZ + 1; ++z) {
                if ((chunk == null || x + this.minX >> 4 != chunk.func_76632_l().field_77276_a || z + this.minZ >> 4 != chunk.func_76632_l().field_77275_b) && (chunk = world.func_72863_F().func_225313_a(x + this.minX >> 4, z + this.minZ >> 4)) == null) {
                    this.biomeData[x][z] = (Biome)ForgeRegistries.BIOMES.getValue(Biomes.field_185440_P.func_240901_a_());
                    continue;
                }
                this.biomeData[x][z] = Objects.requireNonNull(chunk.func_225549_i_()).func_225526_b_(x + this.minX, 255, z + this.minZ);
                this.heightMap[x][z] = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z);
                for (int y = this.minY; y < this.maxY; ++y) {
                    BlockState state;
                    this.blockData[x][y - this.minY][z] = state = chunk.func_180495_p((BlockPos)pos.func_181079_c(x + this.minX, y, z + this.minZ));
                    this.uniqueBlocks.add(state.func_177230_c());
                    this.lightData[x][y - this.minY][z] = (byte)world.func_226658_a_(LightType.SKY, (BlockPos)lightPos.func_181079_c(x + this.minX, y, z + this.minZ));
                }
            }
        }
    }

    public Block getBlock(int x, int y, int z) {
        return this.blockData[x - this.minX][y][z - this.minZ] == null ? Blocks.field_150348_b : this.blockData[x - this.minX][y - this.minY][z - this.minZ].func_177230_c();
    }

    public int getHeighestBlock(int x, int z) {
        return this.heightMap[x - this.minX][z - this.minZ];
    }

    public int getLight(int x, int y, int z) {
        return this.lightData[x - this.minX][y - this.minY][z - this.minZ];
    }

    public BlockState getBlockState(BlockPos pos) {
        return this.getBlockState(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    @Nullable
    public BlockState getBlockState(int x, int y, int z) {
        return this.blockData[x - this.minX][y - this.minY][z - this.minZ];
    }

    public Biome getBiome(int x, int z) {
        return this.biomeData[x - this.minX][z - this.minZ];
    }

    public Set<Block> getUniqueBlocks() {
        return this.uniqueBlocks;
    }

    public boolean isOutOfBounds(BlockPos pos) {
        return this.isOutOfBounds(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean isOutOfBounds(int x, int y, int z) {
        if (x > this.maxX || x < this.minX) {
            return true;
        }
        if (y > this.maxY || y < this.minY) {
            return true;
        }
        return z > this.maxZ || z < this.minZ;
    }
}

