/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.gui.Resources;
import com.pixelmonmod.pixelmon.client.gui.ScreenHelper;
import com.pixelmonmod.pixelmon.client.listener.SendoutListener;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import java.awt.Color;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public enum OverlayScreenState {
    ALL{

        @Override
        public void renderParty(MatrixStack matrix, Minecraft mc, int selectedIndex, Pokemon[] party) {
            MainWindow var5 = mc.func_228018_at_();
            int screenHeight = var5.func_198087_p();
            int leftText = 30;
            int topSideBar = screenHeight / 2 - 100;
            int topOffset = topSideBar + 5;
            float slotHeight = 30.0f;
            int i = -1;
            FontRenderer fontRenderer = mc.field_71466_p;
            if (ClientStorageManager.party.inTemporaryMode()) {
                Color color = ClientStorageManager.party.getTempPartyColor();
                ScreenHelper.drawImageQuad(Resources.dock, matrix, 0.0f, topSideBar, 22.0f, 203.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 0.0f);
                ScreenHelper.drawImageQuad(Resources.padlock, matrix, 0.5f, topSideBar - 9, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 1.0f);
            } else {
                ScreenHelper.drawImageQuad(Resources.dock, matrix, 0.0f, topSideBar, 22.0f, 203.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f, 0.5f, 0.5f, 1.0f, 0.0f);
            }
            for (Pokemon pokemon : party) {
                int offset = 0;
                int yPos = topOffset + (int)((float)(++i) * slotHeight) + 9 + offset;
                if (pokemon != null) {
                    boolean isSentOut = SendoutListener.isInWorld(pokemon.getUUID(), (World)mc.field_71441_e);
                    ScreenHelper.drawImageQuad(Resources.textbox, matrix, leftText - 28, yPos - 10, 123.0f, 34.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    float textureX = -1.0f;
                    float textureY = -1.0f;
                    float[] texturePair = StatusType.getTexturePos(pokemon.getStatus().type);
                    textureX = texturePair[0];
                    textureY = texturePair[1];
                    if (textureX != -1.0f && !pokemon.isFainted()) {
                        ScreenHelper.bindTexture(Resources.status);
                        ScreenHelper.simpleDrawImageQuad(matrix, leftText + 56, yPos + 1, 8.0f, 8.0f, textureX / 768.0f, textureY / 768.0f, (textureX + 240.0f) / 768.0f, (textureY + 240.0f) / 768.0f, 0.0f);
                    }
                    ITextComponent displayName = pokemon.getFormattedDisplayName();
                    ScreenHelper.drawString(matrix, fontRenderer, displayName, (float)(leftText - 2), (float)yPos, 0xFFFFFF, false, true);
                    if (pokemon.getGender() == Gender.MALE && !pokemon.isEgg()) {
                        ScreenHelper.drawImageQuad(Resources.male, matrix, ScreenHelper.getStringWidth(displayName, true) + leftText - 1, yPos, 5.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    } else if (pokemon.getGender() == Gender.FEMALE && !pokemon.isEgg()) {
                        ScreenHelper.drawImageQuad(Resources.female, matrix, ScreenHelper.getStringWidth(displayName, true) + leftText - 1, yPos, 5.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    }
                    ScreenHelper.drawImageQuad(pokemon.getBall().getGUISprite(), matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    ResourceLocation rl = i == selectedIndex ? (pokemon.isFainted() ? Resources.faintedSelected : (isSentOut ? Resources.releasedSelected : Resources.selected)) : (pokemon.isFainted() ? Resources.fainted : (isSentOut ? Resources.released : Resources.normal));
                    ScreenHelper.drawImageQuad(rl, matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    ScreenHelper.drawImageQuad(pokemon.getSprite(), matrix, 1.0f, yPos - 6, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    if (!pokemon.getHeldItem().func_190926_b()) {
                        ScreenHelper.drawImageQuad(Resources.heldItem, matrix, 18.0f, yPos + 13, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    }
                    if (pokemon.isEgg()) continue;
                    String levelString = I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemon.getPokemonLevel();
                    float f = leftText - 1;
                    fontRenderer.getClass();
                    ScreenHelper.drawString(matrix, levelString, f, (float)(yPos + 1 + 9), 0xFFFFFF, false, true);
                    if (pokemon.isFainted()) {
                        String string = I18n.func_135052_a((String)"gui.creativeinv.fainted", (Object[])new Object[0]);
                        float f2 = leftText + 1 + ScreenHelper.getStringWidth(levelString, true);
                        fontRenderer.getClass();
                        ScreenHelper.drawString(matrix, string, f2, (float)(yPos + 1 + 9), 0xFFFFFF, false, true);
                        continue;
                    }
                    String string = I18n.func_135052_a((String)"nbt.hp", (Object[])new Object[0]) + " " + pokemon.getHealth() + "/" + pokemon.getMaxHealth();
                    float f3 = leftText + 2 + ScreenHelper.getStringWidth(levelString, true);
                    fontRenderer.getClass();
                    ScreenHelper.drawString(matrix, string, f3, (float)(yPos + 1 + 9), 0xFFFFFF, false, true);
                    continue;
                }
                ScreenHelper.drawImageQuad(Resources.available, matrix, 5.0f, yPos + 1, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        }
    }
    ,
    SPRITES{

        @Override
        public void renderParty(MatrixStack matrix, Minecraft mc, int selectedIndex, Pokemon[] party) {
            MainWindow var5 = mc.func_228018_at_();
            int screenHeight = var5.func_198087_p();
            int topSideBar = screenHeight / 2 - 100;
            int topOffset = topSideBar + 5;
            float slotHeight = 30.0f;
            int i = -1;
            if (ClientStorageManager.party.inTemporaryMode()) {
                Color color = ClientStorageManager.party.getTempPartyColor();
                ScreenHelper.drawImageQuad(Resources.dock, matrix, 0.0f, topSideBar, 22.0f, 203.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 0.0f);
                ScreenHelper.drawImageQuad(Resources.padlock, matrix, 0.5f, topSideBar - 9, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 1.0f);
            } else {
                ScreenHelper.drawImageQuad(Resources.dock, matrix, 0.0f, topSideBar, 22.0f, 203.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f, 0.5f, 0.5f, 1.0f, 0.0f);
            }
            for (Pokemon pokemon : party) {
                int offset = 0;
                int yPos = topOffset + (int)((float)(++i) * slotHeight) + 9 + offset;
                if (pokemon != null) {
                    boolean isSentOut = SendoutListener.isInWorld(pokemon.getUUID(), (World)mc.field_71441_e);
                    ScreenHelper.drawImageQuad(pokemon.getBall().getGUISprite(), matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    ResourceLocation rl = i == selectedIndex ? (pokemon.isFainted() ? Resources.faintedSelected : (isSentOut ? Resources.releasedSelected : Resources.selected)) : (pokemon.isFainted() ? Resources.fainted : (isSentOut ? Resources.released : Resources.normal));
                    ScreenHelper.drawImageQuad(rl, matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    ScreenHelper.drawImageQuad(pokemon.getSprite(), matrix, 1.0f, yPos - 6, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    if (pokemon.getHeldItem().func_190926_b()) continue;
                    ScreenHelper.drawImageQuad(Resources.heldItem, matrix, 18.0f, yPos + 13, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
                    continue;
                }
                ScreenHelper.drawImageQuad(Resources.available, matrix, 5.0f, yPos + 1, 16.0f, 16.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        }
    }
    ,
    TOP_LEFT_LABEL{

        @Override
        public void renderParty(MatrixStack matrix, Minecraft mc, int selectedIndex, Pokemon[] party) {
            int leftText = 30;
            int yPos = 5;
            Pokemon pokemon = party[selectedIndex];
            boolean isSentOut = SendoutListener.isInWorld(pokemon.getUUID(), (World)mc.field_71441_e);
            float textureX = -1.0f;
            float textureY = -1.0f;
            FontRenderer fontRenderer = mc.field_71466_p;
            ITextComponent displayName = pokemon.getFormattedDisplayName();
            float[] texturePair = StatusType.getTexturePos(pokemon.getStatus().type);
            textureX = texturePair[0];
            textureY = texturePair[1];
            ScreenHelper.drawImageQuad(Resources.textbox, matrix, leftText - 28, yPos - 10, 123.0f, 34.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            if (ClientStorageManager.party.inTemporaryMode()) {
                Color color = ClientStorageManager.party.getTempPartyColor();
                ScreenHelper.drawImageQuad(Resources.padlock, matrix, 30.0f, 5.0f, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 0.0f);
            }
            if (textureX != -1.0f && !pokemon.isFainted()) {
                ScreenHelper.bindTexture(Resources.status);
                ScreenHelper.simpleDrawImageQuad(matrix, leftText + 56, yPos + 1, 8.0f, 8.0f, textureX / 768.0f, textureY / 768.0f, (textureX + 240.0f) / 768.0f, (textureY + 240.0f) / 768.0f, 0.0f);
            }
            if (pokemon.getGender() == Gender.MALE && !pokemon.isEgg()) {
                ScreenHelper.drawImageQuad(Resources.male, matrix, ScreenHelper.getStringWidth(displayName, true) + leftText - 1, yPos, 5.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            } else if (pokemon.getGender() == Gender.FEMALE && !pokemon.isEgg()) {
                ScreenHelper.drawImageQuad(Resources.female, matrix, ScreenHelper.getStringWidth(displayName, true) + leftText - 1, yPos, 5.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            ScreenHelper.drawString(matrix, fontRenderer, displayName, (float)(leftText - 2), (float)yPos, 0xFFFFFF, false, true);
            ScreenHelper.drawImageQuad(pokemon.getBall().getGUISprite(), matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ResourceLocation rl = pokemon.isFainted() ? Resources.faintedSelected : (isSentOut ? Resources.releasedSelected : Resources.selected);
            ScreenHelper.drawImageQuad(rl, matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ScreenHelper.drawImageQuad(pokemon.getSprite(), matrix, 1.0f, yPos - 6, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            if (!pokemon.getHeldItem().func_190926_b()) {
                ScreenHelper.drawImageQuad(Resources.heldItem, matrix, 18.0f, yPos + 13, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            if (!pokemon.isEgg()) {
                String levelString = I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemon.getPokemonLevel();
                float f = leftText - 1;
                fontRenderer.getClass();
                ScreenHelper.drawString(matrix, levelString, f, (float)(yPos + 1 + 9), 0xFFFFFF, false, true);
                if (pokemon.isFainted()) {
                    String string = I18n.func_135052_a((String)"gui.creativeinv.fainted", (Object[])new Object[0]);
                    float f2 = leftText + 1 + ScreenHelper.getStringWidth(levelString, true);
                    fontRenderer.getClass();
                    ScreenHelper.drawString(matrix, string, f2, (float)(yPos + 1 + 9), 0xFFFFFF, false, true);
                } else {
                    String string = I18n.func_135052_a((String)"nbt.hp", (Object[])new Object[0]) + " " + pokemon.getHealth() + "/" + pokemon.getMaxHealth();
                    float f3 = leftText + 2 + ScreenHelper.getStringWidth(levelString, true);
                    fontRenderer.getClass();
                    ScreenHelper.drawString(matrix, string, f3, (float)(yPos + 1 + 9), 0xFFFFFF, false, true);
                }
            }
        }
    }
    ,
    TOP_LEFT{

        @Override
        public void renderParty(MatrixStack matrix, Minecraft mc, int selectedIndex, Pokemon[] party) {
            int yPos = 5;
            Pokemon pokemon = party[selectedIndex];
            boolean isSentOut = SendoutListener.isInWorld(pokemon.getUUID(), (World)mc.field_71441_e);
            if (ClientStorageManager.party.inTemporaryMode()) {
                Color color = ClientStorageManager.party.getTempPartyColor();
                ScreenHelper.drawImageQuad(Resources.padlock, matrix, 30.0f, 5.0f, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 0.0f);
            }
            ScreenHelper.drawImageQuad(pokemon.getBall().getGUISprite(), matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ResourceLocation rl = pokemon.isFainted() ? Resources.faintedSelected : (isSentOut ? Resources.releasedSelected : Resources.selected);
            ScreenHelper.drawImageQuad(rl, matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ScreenHelper.drawImageQuad(pokemon.getSprite(), matrix, 1.0f, yPos - 6, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            if (!pokemon.getHeldItem().func_190926_b()) {
                ScreenHelper.drawImageQuad(Resources.heldItem, matrix, 18.0f, yPos + 13, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        }
    }
    ,
    BOTTOM_LEFT_LABEL{

        @Override
        public void renderParty(MatrixStack matrix, Minecraft mc, int selectedIndex, Pokemon[] party) {
            int leftText = 30;
            int yPos = mc.func_228018_at_().func_198087_p() - 22;
            Pokemon pokemon = party[selectedIndex];
            boolean isSentOut = SendoutListener.isInWorld(pokemon.getUUID(), (World)mc.field_71441_e);
            FontRenderer fontRenderer = mc.field_71466_p;
            ITextComponent displayName = pokemon.getFormattedDisplayName();
            float[] texturePair = StatusType.getTexturePos(pokemon.getStatus().type);
            float textureX = texturePair[0];
            float textureY = texturePair[1];
            ScreenHelper.drawImageQuad(Resources.textbox, matrix, leftText - 28, yPos - 10, 123.0f, 34.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            if (ClientStorageManager.party.inTemporaryMode()) {
                Color color = ClientStorageManager.party.getTempPartyColor();
                ScreenHelper.drawImageQuad(Resources.padlock, matrix, 30.0f, 5.0f, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 0.0f);
            }
            if (textureX != -1.0f && !pokemon.isFainted()) {
                ScreenHelper.bindTexture(Resources.status);
                ScreenHelper.simpleDrawImageQuad(matrix, leftText + 56, yPos + 1, 8.0f, 8.0f, textureX / 768.0f, textureY / 768.0f, (textureX + 240.0f) / 768.0f, (textureY + 240.0f) / 768.0f, 0.0f);
            }
            if (pokemon.getGender() == Gender.MALE && !pokemon.isEgg()) {
                ScreenHelper.drawImageQuad(Resources.male, matrix, ScreenHelper.getStringWidth(displayName, true) + leftText - 1, yPos, 5.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            } else if (pokemon.getGender() == Gender.FEMALE && !pokemon.isEgg()) {
                ScreenHelper.drawImageQuad(Resources.female, matrix, ScreenHelper.getStringWidth(displayName, true) + leftText - 1, yPos, 5.0f, 8.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            ScreenHelper.drawString(matrix, fontRenderer, displayName, (float)(leftText - 2), (float)yPos, 0xFFFFFF, false, true);
            ScreenHelper.drawImageQuad(pokemon.getBall().getGUISprite(), matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ResourceLocation rl = pokemon.isFainted() ? Resources.faintedSelected : (isSentOut ? Resources.releasedSelected : Resources.selected);
            ScreenHelper.drawImageQuad(rl, matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ScreenHelper.drawImageQuad(pokemon.getSprite(), matrix, 1.0f, yPos - 6, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            if (!pokemon.getHeldItem().func_190926_b()) {
                ScreenHelper.drawImageQuad(Resources.heldItem, matrix, 18.0f, yPos + 13, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
            if (!pokemon.isEgg()) {
                String levelString = I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemon.getPokemonLevel();
                float f = leftText - 1;
                fontRenderer.getClass();
                ScreenHelper.drawString(matrix, levelString, f, (float)(yPos + 1 + 9), 0xFFFFFF, false, true);
                if (pokemon.isFainted()) {
                    String string = I18n.func_135052_a((String)"gui.creativeinv.fainted", (Object[])new Object[0]);
                    float f2 = leftText + 1 + ScreenHelper.getStringWidth(levelString, true);
                    fontRenderer.getClass();
                    ScreenHelper.drawString(matrix, string, f2, (float)(yPos + 1 + 9), 0xFFFFFF, false, true);
                } else {
                    String string = I18n.func_135052_a((String)"nbt.hp", (Object[])new Object[0]) + " " + pokemon.getHealth() + "/" + pokemon.getMaxHealth();
                    float f3 = leftText + 2 + ScreenHelper.getStringWidth(levelString, true);
                    fontRenderer.getClass();
                    ScreenHelper.drawString(matrix, string, f3, (float)(yPos + 1 + 9), 0xFFFFFF, false, true);
                }
            }
        }
    }
    ,
    BOTTOM_LEFT{

        @Override
        public void renderParty(MatrixStack matrix, Minecraft mc, int selectedIndex, Pokemon[] party) {
            int yPos = mc.func_228018_at_().func_198087_p() - 22;
            Pokemon pokemon = party[selectedIndex];
            boolean isSentOut = SendoutListener.isInWorld(pokemon.getUUID(), (World)mc.field_71441_e);
            if (ClientStorageManager.party.inTemporaryMode()) {
                Color color = ClientStorageManager.party.getTempPartyColor();
                ScreenHelper.drawImageQuad(Resources.padlock, matrix, 30.0f, 5.0f, 10.0f, 10.0f, 0.0f, 0.0f, 1.0f, 1.0f, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), 0.0f);
            }
            ScreenHelper.drawImageQuad(pokemon.getBall().getGUISprite(), matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ResourceLocation rl = pokemon.isFainted() ? Resources.faintedSelected : (isSentOut ? Resources.releasedSelected : Resources.selected);
            ScreenHelper.drawImageQuad(rl, matrix, -3.0f, yPos - 7, 32.0f, 32.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            ScreenHelper.drawImageQuad(pokemon.getSprite(), matrix, 1.0f, yPos - 6, 24.0f, 24.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            if (!pokemon.getHeldItem().func_190926_b()) {
                ScreenHelper.drawImageQuad(Resources.heldItem, matrix, 18.0f, yPos + 13, 6.0f, 6.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f);
            }
        }
    }
    ,
    NONE{

        @Override
        public void renderParty(MatrixStack matrix, Minecraft mc, int selectedIndex, Pokemon[] party) {
        }
    };

    private static final OverlayScreenState[] VALUES;

    public abstract void renderParty(MatrixStack var1, Minecraft var2, int var3, Pokemon[] var4);

    public OverlayScreenState getNextState() {
        int state = this.ordinal();
        if (state + 1 == VALUES.length) {
            return VALUES[0];
        }
        return VALUES[state + 1];
    }

    static {
        VALUES = OverlayScreenState.values();
    }
}

