/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.api.util.helpers.ResourceLocationHelper;
import java.util.Map;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class NoMirrorShapedRecipe
extends ShapedRecipe {
    private final NonNullList<Ingredient> recipeItems;
    private final ItemStack result;

    public NoMirrorShapedRecipe(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> recipeItems, ItemStack result) {
        super(id, group, width, height, recipeItems, result);
        this.recipeItems = recipeItems;
        this.result = result;
    }

    public boolean func_77569_a(CraftingInventory inventory, World level) {
        for (int i = 0; i <= inventory.func_174922_i() - this.func_192403_f(); ++i) {
            for (int j = 0; j <= inventory.func_174923_h() - this.func_192404_g(); ++j) {
                if (!this.matches(inventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(CraftingInventory inventory, int originX, int originY, boolean invert) {
        for (int i = 0; i < inventory.func_174922_i(); ++i) {
            for (int j = 0; j < inventory.func_174923_h(); ++j) {
                int k = i - originX;
                int l = j - originY;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (k >= 0 && l >= 0 && k < this.func_192403_f() && l < this.func_192404_g()) {
                    ingredient = invert ? (Ingredient)this.recipeItems.get(this.func_192403_f() - k - 1 + l * this.func_192403_f()) : (Ingredient)this.recipeItems.get(k + l * this.func_192403_f());
                }
                if (ingredient.test(inventory.func_70301_a(i + j * inventory.func_174922_i()))) continue;
                return false;
            }
        }
        return true;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<NoMirrorShapedRecipe> {
        private static final ResourceLocation NAME = ResourceLocationHelper.of("pixelmon", "crafting_shaped");

        public NoMirrorShapedRecipe fromJson(ResourceLocation path, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Map map = ShapedRecipe.func_192408_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            String[] astring = ShapedRecipe.func_192407_a((JsonArray)JSONUtils.func_151214_t((JsonObject)json, (String)"pattern"));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList nonnulllist = ShapedRecipe.func_192402_a((String[])astring, (Map)map, (int)i, (int)j);
            ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return new NoMirrorShapedRecipe(path, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public NoMirrorShapedRecipe fromNetwork(ResourceLocation path, PacketBuffer packetBuffer) {
            int i = packetBuffer.func_150792_a();
            int j = packetBuffer.func_150792_a();
            String s = packetBuffer.func_150789_c(Short.MAX_VALUE);
            NonNullList nonnulllist = NonNullList.func_191197_a((int)(i * j), (Object)Ingredient.field_193370_a);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.func_199566_b((PacketBuffer)packetBuffer));
            }
            ItemStack itemstack = packetBuffer.func_150791_c();
            return new NoMirrorShapedRecipe(path, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        public void toNetwork(PacketBuffer packetBuffer, NoMirrorShapedRecipe recipe) {
            packetBuffer.func_150787_b(recipe.func_192403_f());
            packetBuffer.func_150787_b(recipe.func_192404_g());
            packetBuffer.func_180714_a(recipe.func_193358_e());
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.func_199564_a(packetBuffer);
            }
            packetBuffer.func_150788_a(recipe.result);
        }
    }
}

