/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.logic;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBall;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.logic.BallLogic;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.PaletteProperties;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallEntity;
import com.pixelmonmod.pixelmon.entities.pokeballs.PokeBallMode;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;

public class LoveBall
implements BallLogic {
    @Override
    public double getCatchBonus(PokeBall type, PokeBallEntity entity, PlayerEntity thrower, Pokemon pokemon, PokeBallMode mode) {
        double ballBonus = type.getCatchBonus();
        if (mode == PokeBallMode.BATTLE) {
            BattleController bc = BattleRegistry.getBattle(thrower);
            if (bc == null) {
                return ballBonus;
            }
            for (BattleParticipant p : bc.participants) {
                if (p.getEntity() != thrower) continue;
                for (PixelmonWrapper pw : p.controlledPokemon) {
                    if (!pokemon.getSpecies().getName().equals(pw.getPokemonName()) || !pokemon.getGender().isCompatible(pw.getGender())) continue;
                    return 8.0;
                }
            }
        }
        return ballBonus;
    }

    @Override
    public void doAfterEffect(PokeBall type, @Nullable PokeBallEntity entity, PixelmonEntity pixelmon) {
        for (PaletteProperties palette : pixelmon.getGenderProperties().getPalettes()) {
            if (!palette.getName().equalsIgnoreCase("valentine")) continue;
            pixelmon.getPokemon().setPalette(palette);
            return;
        }
    }
}

