/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.items.HeldItem;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;

public class Unburden
extends AbstractAbility {
    private boolean itemUsed = false;

    @Override
    public void onItemChanged(PixelmonWrapper pw, HeldItem newItem) {
        if (!pw.bc.simulateMode) {
            this.itemUsed = newItem == NoItem.noItem;
        }
    }

    @Override
    public int[] modifyStats(PixelmonWrapper user, int[] stats) {
        if (this.itemUsed) {
            int n = BattleStatsType.SPEED.getStatIndex();
            stats[n] = stats[n] * 2;
        }
        return stats;
    }

    @Override
    public void tookDamageTarget(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (target.isFainted() && !user.bc.simulateMode) {
            this.itemUsed = false;
        }
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        if (!newPokemon.bc.simulateMode) {
            this.itemUsed = false;
        }
    }

    @Override
    public boolean needNewInstance() {
        return true;
    }
}

