/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.command;

import com.pixelmonmod.pixelmon.api.command.PixelmonCommandUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.command.CommandSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public abstract class WikiCommandStrategy {
    protected final Set<String> ids;

    public WikiCommandStrategy(String ... ids) {
        this(new HashSet<String>(Arrays.asList(ids)));
    }

    public WikiCommandStrategy(Set<String> ids) {
        if (ids.isEmpty()) {
            throw new IllegalArgumentException("Parameter 'ids' can't be empty!");
        }
        this.ids = ids;
    }

    public abstract void execute(CommandSource var1, Pokemon var2, String[] var3);

    public Optional<ITextComponent> getBanner(CommandSource sender, Pokemon pokemon, String[] args) {
        String id = this.ids.iterator().next();
        String newCmd = "/wiki " + String.join((CharSequence)" ", args) + " " + id;
        return Optional.of(PixelmonCommandUtils.format("pixelmon.command.wiki." + id + ".banner", new Object[0]).func_240700_a_(s -> s.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("pixelmon.command.wiki.banner.hover"))).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, newCmd))));
    }

    public boolean matches(String strategyId) {
        return this.ids.contains(strategyId);
    }

    public int getPriority() {
        return 10;
    }
}

