/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.requirement.AbstractIntegerPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MeltanStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Set;

public class NuggetsFedRequirement
extends AbstractIntegerPokemonRequirement {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"nuggets", "nuggetsfed"});
    private static final int DEFAULT_VALUE = 0;

    public NuggetsFedRequirement() {
        super(KEYS, 0);
    }

    public NuggetsFedRequirement(int value) {
        super(KEYS, 0, value);
    }

    @Override
    public Requirement<Pokemon, PixelmonEntity, Integer> createInstance(Integer value) {
        return new NuggetsFedRequirement(value);
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        if (!pixelmon.getSpecies().is(PixelmonSpecies.MELTAN)) {
            return false;
        }
        MeltanStats stats = pixelmon.getExtraStats(MeltanStats.class).orElse(null);
        if (stats == null) {
            return false;
        }
        return stats.nuggetsFed == this.value;
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        if (!pixelmon.getSpecies().is(PixelmonSpecies.MELTAN)) {
            return;
        }
        MeltanStats stats = pixelmon.getExtraStats(MeltanStats.class).orElse(null);
        if (stats == null) {
            return;
        }
        stats.nuggetsFed = this.value;
    }
}

