/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.platform.forge;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.Resources;
import com.mojang.brigadier.CommandDispatcher;
import cpw.mods.modlauncher.ClassTransformer;
import cpw.mods.modlauncher.EnumerationHelper;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.TransformationServiceDecorator;
import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.forge.classloading.FastAccessTransformerList;
import org.embeddedt.modernfix.forge.classloading.ModernFixResourceFinder;
import org.embeddedt.modernfix.forge.config.NightConfigFixer;
import org.embeddedt.modernfix.forge.init.ModernFixForge;
import org.embeddedt.modernfix.forge.packet.PacketHandler;
import org.embeddedt.modernfix.forge.shadow.mixinextras.MixinExtrasBootstrap;
import org.embeddedt.modernfix.forge.spark.SparkLaunchProfiler;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.util.CommonModUtil;
import org.embeddedt.modernfix.util.DummyList;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.injection.struct.InjectorGroupInfo;

public class ModernFixPlatformHooksImpl
implements ModernFixPlatformHooks {
    private static String verString;
    private Method defineClassMethod = null;
    private static Multimap<String, String> modOptions;

    @Override
    public boolean isClient() {
        return FMLLoader.getDist() == Dist.CLIENT;
    }

    @Override
    public boolean isDedicatedServer() {
        return FMLLoader.getDist().isDedicatedServer();
    }

    @Override
    public String getVersionString() {
        if (verString == null) {
            try {
                verString = ModernFixMixinPlugin.class.getPackage().getImplementationVersion();
                Objects.requireNonNull(verString);
            }
            catch (Throwable e) {
                verString = "[unknown]";
            }
        }
        return verString;
    }

    @Override
    public boolean modPresent(String modId) {
        return FMLLoader.getLoadingModList().getModFileById(modId) != null;
    }

    @Override
    public boolean isDevEnv() {
        return !FMLLoader.isProduction();
    }

    @Override
    public MinecraftServer getCurrentServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    @Override
    public boolean isEarlyLoadingNormally() {
        return LoadingModList.get().getErrors().isEmpty();
    }

    @Override
    public boolean isLoadingNormally() {
        return this.isEarlyLoadingNormally() && ModLoader.isLoadingStateValid();
    }

    @Override
    public TextureAtlasSprite loadTextureAtlasSprite(AtlasTexture atlasTexture, IResourceManager resourceManager, TextureAtlasSprite.Info textureInfo, IResource resource, int atlasWidth, int atlasHeight, int spriteX, int spriteY, int mipmapLevel, NativeImage image) {
        TextureAtlasSprite tas = ForgeHooksClient.loadTextureAtlasSprite((AtlasTexture)atlasTexture, (IResourceManager)resourceManager, (TextureAtlasSprite.Info)textureInfo, (IResource)resource, (int)atlasWidth, (int)atlasHeight, (int)spriteX, (int)spriteY, (int)mipmapLevel, (NativeImage)image);
        if (tas == null) {
            tas = TASConstructor.construct(atlasTexture, resourceManager, textureInfo, resource, atlasWidth, atlasHeight, spriteX, spriteY, mipmapLevel, image);
        }
        return tas;
    }

    @Override
    public Path getGameDirectory() {
        return FMLPaths.GAMEDIR.get();
    }

    @Override
    public void sendPacket(ServerPlayerEntity player, Object packet) {
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }

    @Override
    public void injectPlatformSpecificHacks() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (!(loader instanceof TransformingClassLoader)) {
            throw new IllegalStateException("Expected a TransformingClassLoader");
        }
        try {
            if (ModernFixMixinPlugin.instance.isOptionEnabled("launch.class_search_cache.ModernFixResourceFinder")) {
                Field resourceFinderField = TransformingClassLoader.class.getDeclaredField("resourceFinder");
                resourceFinderField.setAccessible(true);
                Function resourceFinder = ModernFixPlatformHooksImpl.constructResourceFinder();
                Field dclField = TransformingClassLoader.class.getDeclaredField("delegatedClassLoader");
                dclField.setAccessible(true);
                URLClassLoader dcl = (URLClassLoader)dclField.get(loader);
                resourceFinder = EnumerationHelper.mergeFunctors(resourceFinder, (Function)LamdbaExceptionUtils.rethrowFunction(dcl::findResources));
                resourceFinderField.set(loader, resourceFinder);
            }
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            ModernFixMixinPlugin.instance.logger.error("Failed to make classloading changes", (Throwable)e);
        }
        FastAccessTransformerList.attemptReplace();
        try {
            Field groupMembersField = InjectorGroupInfo.class.getDeclaredField("members");
            groupMembersField.setAccessible(true);
            Field noGroupField = InjectorGroupInfo.Map.class.getDeclaredField("NO_GROUP");
            noGroupField.setAccessible(true);
            InjectorGroupInfo noGroup = (InjectorGroupInfo)noGroupField.get(null);
            groupMembersField.set(noGroup, new DummyList());
        }
        catch (NoSuchFieldException groupMembersField) {
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            ModernFixMixinPlugin.instance.logger.error("Failed to patch mixin memory leak", (Throwable)e);
        }
        if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.spark_profile_launch.OnForge")) {
            CommonModUtil.runWithoutCrash(() -> SparkLaunchProfiler.start("launch"), "Failed to start profiler");
        }
        NightConfigFixer.monitorFileWatcher();
        MixinExtrasBootstrap.init();
    }

    private Class<?> injectClassIntoSystemLoader(String className) throws ReflectiveOperationException, IOException {
        ClassLoader systemLoader = ClassTransformer.class.getClassLoader();
        if (this.defineClassMethod == null) {
            this.defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            this.defineClassMethod.setAccessible(true);
        }
        byte[] newTransformerBytes = Resources.toByteArray((URL)ModernFixMixinPlugin.class.getResource("/" + className.replace('.', '/') + ".class"));
        return (Class)this.defineClassMethod.invoke((Object)systemLoader, className, newTransformerBytes, 0, newTransformerBytes.length);
    }

    private static Function<String, Enumeration<URL>> constructResourceFinder() throws ReflectiveOperationException {
        ModernFixResourceFinder.init();
        Field servicesHandlerField = Launcher.class.getDeclaredField("transformationServicesHandler");
        servicesHandlerField.setAccessible(true);
        Object servicesHandler = servicesHandlerField.get(Launcher.INSTANCE);
        Field serviceLookupField = servicesHandler.getClass().getDeclaredField("serviceLookup");
        serviceLookupField.setAccessible(true);
        Map serviceLookup = (Map)serviceLookupField.get(servicesHandler);
        Method getClassLoaderMethod = TransformationServiceDecorator.class.getDeclaredMethod("getClassLoader", new Class[0]);
        getClassLoaderMethod.setAccessible(true);
        Function resourceEnumeratorLocator = ModernFixResourceFinder::findAllURLsForResource;
        for (TransformationServiceDecorator decorator : serviceLookup.values()) {
            Function func = (Function)getClassLoaderMethod.invoke((Object)decorator, new Object[0]);
            if (func == null) continue;
            resourceEnumeratorLocator = EnumerationHelper.mergeFunctors(resourceEnumeratorLocator, (Function)EnumerationHelper.fromOptional((Function)func));
        }
        return resourceEnumeratorLocator;
    }

    @Override
    public void applyASMTransformers(String mixinClassName, ClassNode targetClass) {
        if (mixinClassName.equals("org.embeddedt.modernfix.forge.mixin.bugfix.chunk_deadlock.valhesia.BlockStateBaseMixin")) {
            for (MethodNode m : targetClass.methods) {
                if (!m.name.contains("valhelsia_placeDousedTorch")) continue;
                m.instructions.clear();
                m.instructions.add((AbstractInsnNode)new InsnNode(177));
            }
        }
    }

    @Override
    public void onServerCommandRegister(Consumer<CommandDispatcher<CommandSource>> handler) {
        MinecraftForge.EVENT_BUS.addListener(event -> handler.accept(event.getDispatcher()));
    }

    @Override
    public Multimap<String, String> getCustomModOptions() {
        if (modOptions == null) {
            modOptions = ArrayListMultimap.create();
            for (ModInfo meta : LoadingModList.get().getMods()) {
                meta.getConfigElement(new String[]{"modernfix:integration"}).ifPresent(optionsObj -> {
                    if (optionsObj instanceof Map) {
                        Map options = (Map)optionsObj;
                        options.forEach((key, value) -> {
                            if (key instanceof String && value instanceof String) {
                                modOptions.put((Object)((String)key), (Object)((String)value));
                            }
                        });
                    }
                });
            }
        }
        return modOptions;
    }

    @Override
    public void onLaunchComplete() {
        if (ModernFixMixinPlugin.instance.isOptionEnabled("feature.spark_profile_launch.OnForge")) {
            CommonModUtil.runWithoutCrash(() -> SparkLaunchProfiler.stop("launch"), "Failed to stop profiler");
        }
        ModernFixForge.launchDone = true;
    }

    @Override
    public String getPlatformName() {
        return "Forge";
    }

    static class TASConstructor {
        private static final MethodHandle textureAtlasSpriteConstruct;

        TASConstructor() {
        }

        static TextureAtlasSprite construct(AtlasTexture atlasTexture, IResourceManager resourceManager, TextureAtlasSprite.Info textureInfo, IResource resource, int atlasWidth, int atlasHeight, int spriteX, int spriteY, int mipmapLevel, NativeImage image) {
            try {
                return textureAtlasSpriteConstruct.invokeExact(atlasTexture, textureInfo, mipmapLevel, atlasWidth, atlasHeight, spriteX, spriteY, image);
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException("TextureAtlasSprite construction failed", e);
            }
        }

        static {
            try {
                Constructor<?> constructor = TextureAtlasSprite.class.getDeclaredConstructors()[0];
                constructor.setAccessible(true);
                textureAtlasSpriteConstruct = MethodHandles.lookup().unreflectConstructor(constructor);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

