/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.classloading;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.accesstransformer.AccessTransformer;
import net.minecraftforge.accesstransformer.AccessTransformerEngine;
import net.minecraftforge.accesstransformer.INameHandler;
import net.minecraftforge.accesstransformer.Target;
import net.minecraftforge.accesstransformer.parser.AccessTransformerList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class FastAccessTransformerList
extends AccessTransformerList {
    private FastATMap accessTransformerMap;

    public static void attemptReplace() {
        FastAccessTransformerList myList = new FastAccessTransformerList();
        try {
            Field master = AccessTransformerEngine.class.getDeclaredField("masterList");
            master.setAccessible(true);
            AccessTransformerList masterList = (AccessTransformerList)master.get(AccessTransformerEngine.INSTANCE);
            Field transfomersMap = AccessTransformerList.class.getDeclaredField("accessTransformers");
            transfomersMap.setAccessible(true);
            Map map = (Map)transfomersMap.get(masterList);
            INameHandler nameHandler = (INameHandler)ObfuscationReflectionHelper.getPrivateValue(AccessTransformerList.class, (Object)masterList, (String)"nameHandler");
            myList.setNameHandler(nameHandler);
            myList.accessTransformerMap = new FastATMap(map);
            ObfuscationReflectionHelper.setPrivateValue(AccessTransformerList.class, (Object)((Object)myList), (Object)myList.accessTransformerMap, (String)"accessTransformers");
            master.set(AccessTransformerEngine.INSTANCE, (Object)myList);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public boolean containsClassTarget(Type type) {
        return this.accessTransformerMap.containsType(type);
    }

    private static class FastATMap
    implements Map<Target<?>, AccessTransformer> {
        private final Map<Target<?>, AccessTransformer> delegate = new HashMap();
        private final Set<Type> allContainedTypes = new ObjectOpenHashSet();

        public FastATMap(Map<Target<?>, AccessTransformer> delegate) {
            this.putAll((Map<? extends Target<?>, ? extends AccessTransformer>)delegate);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean containsKey(Object o) {
            return this.delegate.containsKey(o);
        }

        @Override
        public boolean containsValue(Object o) {
            return this.delegate.containsValue(o);
        }

        @Override
        public AccessTransformer get(Object o) {
            return this.delegate.get(o);
        }

        @Override
        @Nullable
        public AccessTransformer put(Target<?> target, AccessTransformer accessTransformer) {
            this.allContainedTypes.add(target.getASMType());
            return this.delegate.put(target, accessTransformer);
        }

        @Override
        public AccessTransformer remove(Object o) {
            if (o instanceof Target) {
                this.allContainedTypes.remove(((Target)o).getASMType());
            }
            return this.delegate.remove(o);
        }

        @Override
        public void putAll(@NotNull Map<? extends Target<?>, ? extends AccessTransformer> map) {
            for (Target<?> key : map.keySet()) {
                this.allContainedTypes.add(key.getASMType());
            }
            this.delegate.putAll(map);
        }

        @Override
        public void clear() {
            this.allContainedTypes.clear();
            this.delegate.clear();
        }

        @Override
        @NotNull
        public Set<Target<?>> keySet() {
            return this.delegate.keySet();
        }

        @Override
        @NotNull
        public Collection<AccessTransformer> values() {
            return this.delegate.values();
        }

        @Override
        @NotNull
        public Set<Map.Entry<Target<?>, AccessTransformer>> entrySet() {
            return this.delegate.entrySet();
        }

        public boolean containsType(Type type) {
            return this.allContainedTypes.contains(type);
        }
    }
}

