/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.perf.compress_biome_container;

import it.unimi.dsi.fastutil.objects.Reference2ShortMap;
import it.unimi.dsi.fastutil.objects.Reference2ShortOpenHashMap;
import net.minecraft.util.BitArray;
import net.minecraft.util.IObjectIntIterable;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.provider.BiomeProvider;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BiomeContainer.class})
public class MixinBiomeContainer {
    @Mutable
    @Shadow
    @Final
    private Biome[] field_227054_f_;
    @Shadow
    @Final
    private IObjectIntIterable<Biome> field_242704_g;
    @Shadow
    @Final
    private static int field_227052_d_;
    private Biome[] palette;
    private BitArray intArray;

    @Inject(method={"<init>(Lnet/minecraft/core/IdMap;[I)V"}, at={@At(value="RETURN")}, require=0)
    private void reinit1(IObjectIntIterable p_i241970_1_, int[] p_i241970_2_, CallbackInfo ci) {
        this.createCompact();
    }

    @Inject(method={"<init>(Lnet/minecraft/core/IdMap;[Lnet/minecraft/world/level/biome/Biome;)V"}, at={@At(value="RETURN")})
    private void reinit2(IObjectIntIterable p_i241971_1_, Biome[] p_i241971_2_, CallbackInfo ci) {
        this.createCompact();
    }

    @Inject(method={"<init>(Lnet/minecraft/core/IdMap;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/world/level/biome/BiomeSource;)V"}, at={@At(value="RETURN")})
    private void reinit3(IObjectIntIterable p_i241968_1_, ChunkPos p_i241968_2_, BiomeProvider p_i241968_3_, CallbackInfo ci) {
        this.createCompact();
    }

    @Inject(method={"<init>(Lnet/minecraft/core/IdMap;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/world/level/biome/BiomeSource;[I)V"}, at={@At(value="RETURN")})
    private void reinit4(IObjectIntIterable p_i241969_1_, ChunkPos p_i241969_2_, BiomeProvider p_i241969_3_, int[] p_i241969_4_, CallbackInfo ci) {
        this.createCompact();
    }

    private void createCompact() {
        if (this.intArray != null || this.field_227054_f_[0] == null) {
            return;
        }
        Reference2ShortOpenHashMap<Biome> paletteTable = this.createPalette();
        Biome[] paletteIndexed = new Biome[paletteTable.size()];
        for (Reference2ShortMap.Entry entry : paletteTable.reference2ShortEntrySet()) {
            paletteIndexed[entry.getShortValue()] = (Biome)entry.getKey();
        }
        int packedIntSize = Math.max(2, MathHelper.func_151241_e((int)paletteTable.size()));
        BitArray integerArray = new BitArray(packedIntSize, BiomeContainer.field_227049_a_);
        Biome prevBiome = null;
        int prevId = -1;
        for (int i = 0; i < this.field_227054_f_.length; ++i) {
            int id;
            Biome biome = this.field_227054_f_[i];
            if (prevBiome == biome) {
                id = prevId;
            } else {
                id = paletteTable.getShort((Object)biome);
                if (id < 0) {
                    throw new IllegalStateException("Palette is missing entry: " + biome);
                }
                prevId = id;
                prevBiome = biome;
            }
            integerArray.func_188141_a(i, id);
        }
        this.palette = paletteIndexed;
        this.intArray = integerArray;
        this.field_227054_f_ = null;
    }

    private Reference2ShortOpenHashMap<Biome> createPalette() {
        Reference2ShortOpenHashMap map = new Reference2ShortOpenHashMap();
        map.defaultReturnValue((short)Short.MIN_VALUE);
        Biome prevObj = null;
        short id = 0;
        for (Biome obj : this.field_227054_f_) {
            if (obj == prevObj) continue;
            if (map.getShort((Object)obj) < 0) {
                short s = id;
                id = (short)(id + 1);
                map.put((Object)obj, s);
            }
            prevObj = obj;
        }
        return map;
    }

    @Overwrite
    public int[] func_227055_a_() {
        int size = this.intArray.func_188144_b();
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = this.field_242704_g.func_148757_b((Object)this.palette[this.intArray.func_188142_a(i)]);
        }
        return array;
    }

    @Overwrite
    public Biome func_225526_b_(int biomeX, int biomeY, int biomeZ) {
        int x = biomeX & BiomeContainer.field_227050_b_;
        int y = MathHelper.func_76125_a((int)biomeY, (int)0, (int)BiomeContainer.field_227051_c_);
        int z = biomeZ & BiomeContainer.field_227050_b_;
        return this.palette[this.intArray.func_188142_a(y << field_227052_d_ + field_227052_d_ | z << field_227052_d_ | x)];
    }
}

