/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.bugfix.chunk_deadlock;

import com.mojang.datafixers.util.Either;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import org.embeddedt.modernfix.ModernFix;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerChunkProvider.class}, priority=1100)
public abstract class ServerChunkCacheMixin {
    @Shadow
    @Final
    private Thread field_217241_g;
    @Shadow
    @Final
    public ServerWorld field_73251_h;
    @Shadow
    @Final
    private ServerChunkProvider.ChunkExecutor field_217243_i;
    private final boolean debugDeadServerAccess = Boolean.getBoolean("modernfix.debugBadChunkloading");

    @Shadow
    protected abstract CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_217233_c(int var1, int var2, ChunkStatus var3, boolean var4);

    @Inject(method={"getChunk"}, at={@At(value="HEAD")}, cancellable=true)
    private void bailIfServerDead(int chunkX, int chunkZ, ChunkStatus requiredStatus, boolean load, CallbackInfoReturnable<IChunk> cir) {
        CompletableFuture future;
        if (!this.field_73251_h.func_73046_m().func_71278_l() && !this.field_217241_g.isAlive()) {
            ModernFix.LOGGER.fatal("A mod is accessing chunks from a stopped server (this will also cause memory leaks)");
            if (this.debugDeadServerAccess) {
                new Exception().printStackTrace();
            }
            cir.setReturnValue((Object)new EmptyChunk((World)this.field_73251_h, new ChunkPos(chunkX, chunkZ)));
        } else if (Thread.currentThread() != this.field_217241_g && !(future = CompletableFuture.supplyAsync(() -> this.func_217233_c(chunkX, chunkZ, requiredStatus, false), (Executor)this.field_217243_i).join()).isDone()) {
            Either resultingChunk = null;
            try {
                resultingChunk = (Either)future.get(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                // empty catch block
            }
            if (resultingChunk != null && resultingChunk.left().isPresent()) {
                cir.setReturnValue((Object)((IChunk)resultingChunk.left().get()));
                return;
            }
            if (this.debugDeadServerAccess) {
                ModernFix.LOGGER.warn("Async loading of a chunk was requested, this might not be desirable", (Throwable)new Exception());
            }
            try {
                resultingChunk = (Either)future.get(10L, TimeUnit.SECONDS);
                if (resultingChunk.left().isPresent()) {
                    cir.setReturnValue((Object)((IChunk)resultingChunk.left().get()));
                    return;
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                ModernFix.LOGGER.error("Async chunk load took way too long, this needs to be reported to the appropriate mod.", (Throwable)e);
            }
        }
    }
}

