/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StaticMap {
    private static final Map<String, Object> MAP = Collections.synchronizedMap(new HashMap());

    public static boolean contains(String key) {
        return MAP.containsKey(key);
    }

    public static Object get(String key) {
        return MAP.get(key);
    }

    public static void put(String key, Object val) {
        MAP.put(key, val);
    }

    public static int getInt(String key, int def) {
        Object val = MAP.get(key);
        if (!(val instanceof Integer)) {
            return def;
        }
        Integer valInt = (Integer)val;
        return valInt;
    }

    public static int putInt(String key, int val) {
        int valPrev = StaticMap.getInt(key, 0);
        Integer valObj = val;
        MAP.put(key, valObj);
        return valPrev;
    }

    public static long getLong(String key, long def) {
        Object val = MAP.get(key);
        if (!(val instanceof Long)) {
            return def;
        }
        Long valLong = (Long)val;
        return valLong;
    }

    public static void putLong(String key, long val) {
        Long valObj = val;
        MAP.put(key, valObj);
    }

    public static long putLong(String key, long val, long def) {
        long valPrev = StaticMap.getLong(key, def);
        Long valObj = val;
        MAP.put(key, valObj);
        return valPrev;
    }

    public static long addLong(String key, long val, long def) {
        long valMap = StaticMap.getLong(key, def);
        StaticMap.putLong(key, valMap += val);
        return valMap;
    }
}

