/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.upload;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import fudge.notenoughcrashes.NecConfig;
import fudge.notenoughcrashes.NotEnoughCrashes;
import fudge.notenoughcrashes.upload.CrashyUpload;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public final class LegacyCrashLogUpload {
    private static final String GIST_ACCESS_TOKEN = LegacyCrashLogUpload.GIST_ACCESS_TOKEN_PART_1() + LegacyCrashLogUpload.GIST_ACCESS_TOKEN_PART_2();

    private static String GIST_ACCESS_TOKEN_PART_1() {
        return "dc07dacff0c2cf84f706";
    }

    private static String GIST_ACCESS_TOKEN_PART_2() {
        return "8ac0fd6a757d53b81233";
    }

    public static String upload(String text) throws IOException {
        return LegacyCrashLogUpload.upload(text, new HashSet<NecConfig.CrashLogUploadDestination>());
    }

    public static String upload(String text, Set<NecConfig.CrashLogUploadDestination> failedUploadDestinations) throws IOException {
        NecConfig.CrashLogUploadDestination uploadDestination = LegacyCrashLogUpload.chooseUploadDestination(failedUploadDestinations);
        try {
            switch (uploadDestination) {
                case CRASHY: {
                    return CrashyUpload.uploadToCrashySync(text);
                }
                case GIST: {
                    return LegacyCrashLogUpload.uploadToGist(text);
                }
                case HASTE: {
                    return LegacyCrashLogUpload.uploadToHaste(text);
                }
                case PASTEBIN: {
                    return LegacyCrashLogUpload.uploadToPasteBin(text);
                }
                case BYTEBIN: {
                    return LegacyCrashLogUpload.uploadToByteBin(text);
                }
            }
            throw new IllegalStateException("Impossible");
        }
        catch (IOException e) {
            NotEnoughCrashes.getLogger().error("Uploading to " + (Object)((Object)uploadDestination) + " failed, using another destination as fallback.", (Throwable)e);
            failedUploadDestinations.add(uploadDestination);
            return LegacyCrashLogUpload.upload(text, failedUploadDestinations);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static NecConfig.CrashLogUploadDestination chooseUploadDestination(Set<NecConfig.CrashLogUploadDestination> failedUploadTypes) throws IOException {
        if (failedUploadTypes.isEmpty()) {
            return NecConfig.instance().crashlogUpload.destination;
        }
        Optional<NecConfig.CrashLogUploadDestination> selectedDestination = Arrays.stream(NecConfig.CrashLogUploadDestination.values()).filter(destination -> destination.defaultPriority != null && !failedUploadTypes.contains(destination)).min(Comparator.comparingInt(destination -> destination.defaultPriority));
        return selectedDestination.orElseThrow(() -> new IOException("All upload destinations failed!"));
    }

    private static String uploadToGist(final String text) throws IOException {
        NecConfig.Gist config = NecConfig.instance().crashlogUpload.gist;
        String configUploadKey = config.accessToken;
        String uploadKey = configUploadKey.isEmpty() ? GIST_ACCESS_TOKEN : configUploadKey;
        HttpPost post = new HttpPost("https://api.github.com/gists");
        final String fileName = "crash.txt";
        post.addHeader("Authorization", "token " + uploadKey);
        GistPost body = new GistPost(!config.unlisted, new HashMap(){
            {
                this.put(fileName, new GistFile(text));
            }
        });
        post.setEntity((HttpEntity)LegacyCrashLogUpload.createStringEntity(new Gson().toJson((Object)body)));
        String customUserAgent = NecConfig.instance().crashlogUpload.customUserAgent;
        if (!customUserAgent.isEmpty()) {
            post.setHeader("User-Agent", customUserAgent);
        }
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            JsonObject responseJson = (JsonObject)new Gson().fromJson(responseString, JsonObject.class);
            String string = responseJson.getAsJsonObject("files").getAsJsonObject(fileName).getAsJsonPrimitive("raw_url").getAsString();
            return string;
        }
    }

    private static String uploadToHaste(String str) throws IOException {
        String url = NecConfig.instance().crashlogUpload.hasteUrl;
        String customUserAgent = NecConfig.instance().crashlogUpload.customUserAgent;
        HttpPost post = new HttpPost(url + "documents");
        post.setEntity((HttpEntity)LegacyCrashLogUpload.createStringEntity(str));
        if (!customUserAgent.isEmpty()) {
            post.setHeader("User-Agent", customUserAgent);
        }
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            JsonObject responseJson = (JsonObject)new Gson().fromJson(responseString, JsonObject.class);
            String hasteKey = responseJson.getAsJsonPrimitive("key").getAsString();
            String string = url + "raw/" + hasteKey;
            return string;
        }
    }

    private static String uploadToPasteBin(String text) throws IOException {
        HttpPost post = new HttpPost("https://pastebin.com/api/api_post.php");
        NecConfig.Pastebin config = NecConfig.instance().crashlogUpload.pastebin;
        String pastebinUploadKey = config.uploadKey;
        String pastebinPrivacy = config.privacy.apiValue;
        String pastebinExpiryKey = config.expiry.pastebinExpiryKey;
        List<NameValuePair> params = Arrays.asList(new BasicNameValuePair("api_dev_key", pastebinUploadKey), new BasicNameValuePair("api_option", "paste"), new BasicNameValuePair("api_paste_code", text), new BasicNameValuePair("api_paste_name", "crash.txt"), new BasicNameValuePair("api_paste_format", "yaml"), new BasicNameValuePair("api_paste_expire_date", pastebinExpiryKey), new BasicNameValuePair("api_paste_private", pastebinPrivacy));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            String string = responseString.replace("https://pastebin.com/", "https://pastebin.com/raw/");
            return string;
        }
    }

    private static String uploadToByteBin(String text) throws IOException {
        NecConfig.CrashUpload config = NecConfig.instance().crashlogUpload;
        String url = NecConfig.instance().crashlogUpload.bytebinUrl;
        HttpPost post = new HttpPost(url + "post");
        String userAgent = config.customUserAgent.isEmpty() ? String.join((CharSequence)" ", Arrays.toString(post.getHeaders("User-Agent"))).concat(" NotEnoughCrashes") : config.customUserAgent;
        post.setHeader("User-Agent", userAgent);
        post.addHeader("Content-Type", "text/plain");
        post.setEntity((HttpEntity)LegacyCrashLogUpload.createStringEntity(text));
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            JsonObject responseJson = (JsonObject)new Gson().fromJson(responseString, JsonObject.class);
            String bytebinKey = responseJson.getAsJsonPrimitive("key").getAsString();
            String string = url + bytebinKey;
            return string;
        }
    }

    public static StringEntity createStringEntity(String text) {
        return new StringEntity(text, StandardCharsets.UTF_16);
    }

    private static class GistFile {
        public String content;

        public GistFile(String content) {
            this.content = content;
        }
    }

    private static class GistPost {
        @SerializedName(value="public")
        public boolean isPublic;
        public Map<String, GistFile> files;

        public GistPost(boolean isPublic, Map<String, GistFile> files) {
            this.isPublic = isPublic;
            this.files = files;
        }
    }
}

